package com.bizvane.connectorservice.entity.out.huairen;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.lang.math.RandomUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@Data
public class HuaiRenGetStocksResponseVO<K,V> extends HashMap<K,V> {

    @Data
    public static class HuaiRenStockChildVO{

        private Integer stock;

        private String skuCode;
    }

    /**
     * convert
     * @param mapResult
     * @return
     */
    public static List<HuaiRenGetStocksResponseVO.HuaiRenStockChildVO> convert(HuaiRenGetStocksResponseVO mapResult){
        Set set = mapResult.keySet();
        ArrayList<HuaiRenGetStocksResponseVO.HuaiRenStockChildVO> huaiRenStockChildVOS = new ArrayList<HuaiRenGetStocksResponseVO.HuaiRenStockChildVO>(set.size());

        for (Object key : set) {
            HuaiRenGetStocksResponseVO.HuaiRenStockChildVO huaiRenStockChildVO = JSON.parseObject(JSON.toJSONString(mapResult.get(key)), HuaiRenGetStocksResponseVO.HuaiRenStockChildVO.class);
            huaiRenStockChildVO.setSkuCode(key.toString());
            huaiRenStockChildVOS.add(huaiRenStockChildVO);
        }

        return huaiRenStockChildVOS;
    }

    /**
     * convert
     * @param stringResult
     * @return
     */
    public static List<HuaiRenGetStocksResponseVO.HuaiRenStockChildVO> convert(String stringResult){

        HuaiRenGetStocksResponseVO huaiRenGetStocksResponseVO = JSON.parseObject(stringResult,HuaiRenGetStocksResponseVO.class);
        List<HuaiRenStockChildVO> convert = convert(huaiRenGetStocksResponseVO);

        return convert;
    }


    /**
     * 随机生成
     * @param skuCodes
     * @return
     */
    public static HuaiRenGetStocksResponseVO randomObejct(String skuCodes){
        String[] split = skuCodes.split(",");

        HuaiRenGetStocksResponseVO huaiRenGetStocksResponseVO = new HuaiRenGetStocksResponseVO();

        for (int i = 0; i < split.length; i++) {
            HuaiRenGetStocksResponseVO.HuaiRenStockChildVO huaiRenStockChildVO = new HuaiRenGetStocksResponseVO.HuaiRenStockChildVO();
            huaiRenStockChildVO.setStock(RandomUtils.nextInt(50));

            huaiRenGetStocksResponseVO.put(split[i], huaiRenStockChildVO);
        }
        return huaiRenGetStocksResponseVO;
    }
}
