package com.bizvane.connectorservice.entity.icrm;

import com.bizvane.connectorservice.entity.base.BaseModel;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;


@Data
public class RechargeCardGiveRequestVo extends BaseModel{

    /**
     * 转赠类型 1：转赠  2：受赠  3：转赠失败
     */
    private Integer type;

    /**
     * 储蓄卡号
     */
    private String rechargeCardId;

    /**
     * 变更本金金额
     */
    private BigDecimal amount;

    /**
     * 	变更赠送金额
     */
    private BigDecimal giveAmount;

    /**
     * 转赠/领取时间
     */
    @DateTimeFormat( pattern="yyyy-MM-dd HH:mm:ss")
    private Date giveDate;

    /**
     * 	当前本金总额
     */
    private BigDecimal currentAmount;

    /**
     * 	当前赠送金额总余额
     */
    private BigDecimal currentGiveAmount;

    /**
     *  转增/受赠人储蓄卡号 若为转增，则显示受赠人；若为受赠，则显示转增人；若转增失败，则显示转增人
     */
    private String giveOrReceiveCard;

    /**
     * 转赠流水号
     */
    private String recordNo;

    /**
     * 有效期
     */
    @DateTimeFormat( pattern="yyyy-MM-dd HH:mm:ss")
    private Date validDate;
}
