package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.icrm.RechargeCardRecordListResponseVO;
import com.bizvane.connectorservice.entity.icrm.RechargeCardRecordRequestVO;
import com.bizvane.connectorservice.entity.yzw.RechargeCardInfoRequestVo;
import com.bizvane.connectorservice.entity.yzw.RechargeCardInfoResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


/**
 * @author xiao.shu
 * @date 2019/10/15
 * @description
 */

@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/yzw")
public interface YzwConnectorServiceFeign {

    /**
     * 获取储值卡资料
     * @param requestVo
     * @return
     */
    @RequestMapping(value ="getRechargeCardInfo",method = RequestMethod.POST)
    ResponseData<List<RechargeCardInfoResponseVo>> getRechargeRecords(RechargeCardInfoRequestVo requestVo);

    /**
     * 获取储值卡流水
     * @param requestVO
     * @return
     */
    @RequestMapping(value ="getRechargeCardRecords",method = RequestMethod.POST)
    Result<RechargeCardRecordListResponseVO> getRechargeCardRecords(RechargeCardRecordRequestVO requestVO);



}
