package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.ConnectConfigVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: liuying@bizvane.cn
 * @Date: 2019/3/4 10:32
 * @Version 1.0
 */
@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}")
public interface OutOfConnectServiceFeign {

    /**
     * 新增品牌接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "addBrand", produces  = MediaType.APPLICATION_JSON_VALUE)
    Result addConnectConfig(@RequestBody ConnectConfigVO requestVO);

    /**
     * 更新品牌接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "updateBrand", produces  = MediaType.APPLICATION_JSON_VALUE)
    Result updateConnectConfig(@RequestBody ConnectConfigVO requestVO);

    /**
     * 获取所有注册的客户端
     * @return
     */
    @RequestMapping(value = "queryHeartbeatClientList", produces  = MediaType.APPLICATION_JSON_VALUE)
    Result queryHeartbeatClientList();

    /**
     * 根据品牌id获取注册信息
     * @param onlineBrandId
     * @return 不存在则返回null
     */
    @PostMapping(value = "queryHeartbeatClientByBrandId", produces  = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Result queryHeartbeatClientByBrandId(@RequestParam Long onlineBrandId);

}
