package com.bizvane.utils.tokens;

import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.core.NamedThreadLocal;
import org.springframework.lang.Nullable;

import java.util.Map;

/**
 * @author lijunke
 */
public class TokenApplicationContext {

    private static final ThreadLocal<Map> requestAttributesHolder = new NamedThreadLocal("Application attributes");
    private static final ThreadLocal<Map> inheritableRequestAttributesHolder = new NamedInheritableThreadLocal("Application context");

    public TokenApplicationContext() {
    }

    public static void resetRequestAttributes() {
        requestAttributesHolder.remove();
        inheritableRequestAttributesHolder.remove();
    }

    public static void setRequestAttributes(@Nullable Map attributes) {
        setRequestAttributes(attributes, false);
    }

    public static void setRequestAttributes(@Nullable Map attributes, boolean inheritable) {
        if (attributes == null) {
            resetRequestAttributes();
        } else if (inheritable) {
            inheritableRequestAttributesHolder.set(attributes);
            requestAttributesHolder.remove();
        } else {
            requestAttributesHolder.set(attributes);
            inheritableRequestAttributesHolder.remove();
        }
    }

    @Nullable
    public static Map getRequestAttributes() {
        Map attributes = requestAttributesHolder.get();
        if (attributes == null) {
            attributes = inheritableRequestAttributesHolder.get();
        }
        return attributes;
    }

}
