/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.sm;

import com.bizvane.utils.sm.SM3Utils;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Utils {
    private static final Logger log = LoggerFactory.getLogger(SM4Utils.class);

    public static String decryptSM4(String encryptedData, String sm4Key) {
        try {
            SM4Utils.ensureBouncyCastleRegistered();
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
            SecretKeySpec keySpec = new SecretKeySpec(SM4Utils.hexStringToByteArray(sm4Key), "SM4");
            cipher.init(2, keySpec);
            byte[] data = SM4Utils.hexStringToByteArray(encryptedData);
            byte[] decryptedData = cipher.doFinal(data);
            return new String(decryptedData);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u62a5\u9519:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException(String.format("\u57fa\u4e8eSM4\u7b97\u6cd5\u89e3\u5bc6\u5f02\u5e38\uff0c\u5bc6\u6587\uff1a%s\uff0c\u5bc6\u94a5\uff1a%s", encryptedData, sm4Key), e);
        }
    }

    public static String encryptSM4(String data, String sm4Key) {
        try {
            SM4Utils.ensureBouncyCastleRegistered();
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
            SecretKeySpec keySpec = new SecretKeySpec(SM4Utils.hexStringToByteArray(sm4Key), "SM4");
            cipher.init(1, keySpec);
            byte[] encryptedData = cipher.doFinal(data.getBytes());
            return SM4Utils.byteArrayToHex(encryptedData);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u62a5\u9519:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException(String.format("\u57fa\u4e8eSM4\u7b97\u6cd5\u89e3\u5bc6\u5f02\u5e38\uff0c\u660e\u6587\uff1a%s\uff0c\u5bc6\u94a5\uff1a%s", data, sm4Key), e);
        }
    }

    public static String byteArrayToHex(byte[] bytes) {
        return SM3Utils.byteArrayToHex(bytes);
    }

    private static byte[] hexStringToByteArray(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureBouncyCastleRegistered() {
        if (Security.getProvider("BC") != null) return;
        Class<SM4Utils> clazz = SM4Utils.class;
        synchronized (SM4Utils.class) {
            if (Security.getProvider("BC") != null) return;
            Security.addProvider((Provider)new BouncyCastleProvider());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

