package com.bizvane.utils.commonutils;

import com.bizvane.utils.tokens.TokenApplicationContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Map;

/**
 * @author lijunke
 */
@Configuration
public class FeignConfig implements RequestInterceptor {

    public static final String BIZVANE_REQUEST_BUSINESS_ID = "bizvane-request-business-id";

    @Override
    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            Enumeration<String> headerNames = request.getHeaderNames();
            if (headerNames != null) {
                String name, values;
                while (headerNames.hasMoreElements()) {
                    name = headerNames.nextElement();
                    if ("content-type".equals(name.toLowerCase())) {
                        continue;
                    }
                    values = request.getHeader(name);
                    requestTemplate.header(name, values);
                }
            }
        }
        if(TokenApplicationContext.getRequestAttributes() == null) {
            return;
        }
        if(!TokenApplicationContext.getRequestAttributes().isEmpty()) {
            Map<String,String> map = TokenApplicationContext.getRequestAttributes();
            if(StringUtils.isNotBlank(map.get(BIZVANE_REQUEST_BUSINESS_ID))) {
                requestTemplate.header(BIZVANE_REQUEST_BUSINESS_ID, map.get(BIZVANE_REQUEST_BUSINESS_ID));
            }
        }
    }
}
