/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.commonutils;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils
implements Serializable {
    private static final long serialVersionUID = -4016651052102523560L;
    private static final String FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String FORMAT_YYYYMMDD_HHMMSS = "yyyy-MM-dd HH:mm:ss";
    private static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);

    private DateUtils() {
    }

    public static void main(String[] args) {
        System.out.println("Start of Day: " + String.valueOf(DateUtils.getXdayAfterEnd(3)));
    }

    public static LocalDateTime getXdayAfterEnd(int x) {
        LocalDateTime time = LocalDateTime.now().plusDays(x).toLocalDate().atTime(LocalTime.MAX);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDD_HHMMSS);
        String formattedDateTimeString = time.format(formatter);
        return LocalDateTime.parse(formattedDateTimeString, formatter);
    }

    public static LocalDateTime getPastDays(LocalDateTime dateTime, int days) {
        return dateTime.minusDays(days);
    }

    public static LocalDateTime getPastHours(LocalDateTime dateTime, int hours) {
        return dateTime.minusHours(hours);
    }

    public static LocalDateTime getPastMinutes(LocalDateTime dateTime, int minutes) {
        return dateTime.minusMinutes(minutes);
    }

    public static String formatDateTime(LocalDateTime dateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return dateTime.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDD_HHMMSS);
        return localDateTime.format(formatter);
    }

    public static String formatYyyymmddhhmmss(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDDHHMMSS);
        return localDateTime.format(formatter);
    }

    public static String formatYyyymmdd(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDD);
        return localDateTime.format(formatter);
    }

    public static LocalDateTime pareYyyymmdd(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDD);
        return LocalDateTime.parse(date, formatter);
    }

    public static LocalDateTime pareFORMAT_YYYYMMDD_HHMMSS(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDD_HHMMSS);
        return LocalDateTime.parse(date, formatter);
    }

    public static LocalDateTime getStartOfDay(LocalDateTime dateTime) {
        return dateTime.with(LocalTime.MIN);
    }

    public static LocalDateTime getEndOfDay(LocalDateTime dateTime) {
        return dateTime.with(LocalTime.MAX);
    }

    public static LocalDateTime getStartOfDay() {
        return LocalDateTime.now().with(LocalTime.MIN);
    }

    public static LocalDateTime getStartOfWeek() {
        return LocalDateTime.now().with(DayOfWeek.MONDAY).with(LocalTime.MIN);
    }

    public static LocalDateTime getStartOfMonth() {
        return LocalDateTime.now().withDayOfMonth(1).with(LocalTime.MIN);
    }

    public static LocalDateTime getStartOfYear() {
        return LocalDateTime.now().withDayOfYear(1).with(LocalTime.MIN);
    }

    public static Date longFormatDate(Long time) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
            String d = format.format(time);
            return format.parse(d);
        }
        catch (Exception e) {
            logger.info("", (Throwable)e);
            return null;
        }
    }

    public static String dateFormatTime(Date currentTime) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String dateFormatDate(Date currentTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getStringNoDate(Date currentTime) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_YYYYMMDDHHMMSS);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static Date getTimeByMinute(int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, minute);
        return calendar.getTime();
    }

    public static int daysBetween(String smdate, String bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(smdate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(sdf.parse(bdate));
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static String getNowYearMothDay() {
        Object dString = "";
        try {
            Calendar now = Calendar.getInstance();
            dString = String.valueOf(now.get(1)) + String.valueOf(now.get(2) + 1) + String.valueOf(now.get(5)) + String.valueOf(now.get(11)) + String.valueOf(now.get(12)) + String.valueOf(now.get(13));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dString;
    }

    public static String formatStringByPattern(String date) {
        logger.info("date:" + date);
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYYMMDDHHMMSS);
        SimpleDateFormat format1 = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String dateTimeStr = "";
        try {
            dateTimeStr = format1.format(format.parse(date));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("result:" + dateTimeStr);
        return dateTimeStr;
    }

    public static String DateFormatString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String newDate = sdf.format(date);
        return newDate;
    }

    public static Date StringFormatDate(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date stringFormatTime(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        Date date = null;
        try {
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static long StringFormartLong(String dateStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = dateFormat.parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getNowDate() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        return df.format(new Date());
    }

    public static int daysOfTwoCount(Date fDate, Date lDate) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTime(fDate);
        int day1 = aCalendar.get(6);
        aCalendar.setTime(lDate);
        int day2 = aCalendar.get(6);
        return day2 - day1;
    }

    public static Date getTodayStartTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String sDate = format.format(date);
        Date startTime = null;
        try {
            startTime = sdf.parse(sDate + " 00:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return startTime;
    }

    public static Date getTodayEndTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String sDate = format.format(date);
        Date endTime = null;
        try {
            endTime = sdf.parse(sDate + " 23:59:59");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return endTime;
    }

    public static Date getThisMonthStartTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String sDate = format.format(date);
        Date startTime = null;
        try {
            startTime = sdf.parse(sDate + " 00:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return startTime;
    }

    public static Date getThisMonthEndTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String sDate = format.format(date);
        Date endTime = null;
        try {
            endTime = sdf.parse(sDate + " 23:59:59");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return endTime;
    }

    @Deprecated
    public static Date getSpecifiedDayBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(formatDate);
        int day = c.get(5);
        c.set(5, day - before);
        return c.getTime();
    }

    @Deprecated
    public static Date getSpecifiedHourBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(formatDate);
        int day = c.get(10);
        c.set(5, day - before);
        return c.getTime();
    }

    @Deprecated
    public static Date getSpecifiedMinuteBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(formatDate);
        int day = c.get(12);
        c.set(5, day - before);
        return c.getTime();
    }

    public static Date getFormateStringDate(String str) {
        Date date = null;
        try {
            date = org.apache.commons.lang3.time.DateUtils.parseDate((String)str, (String[])new String[]{"yyyy-MM-dd"});
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getSpecifiedDayBefore(String specifiedDay) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yy-MM-dd").parse(specifiedDay);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 1);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayBefore;
    }

    @Deprecated
    public static String formatYYYYMMDDHHmmSS(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYYMMDD_HHMMSS);
        return format.format(date);
    }
}

