package com.bizvane.utils.enumutils;

/**
 * @author chen.li
 * @date on 2018/6/21 10:30
 * @description 系统响应返回码枚举类，此处定义所有该系统对外响应的返回码及释义
 * @version 1.0
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public enum SysResponseEnum {
    SUCCESS(0, "操作成功！"),
    FAILED(-1, "操作失败！"),
    NULLPOINTEREXCEPTION(-1000, "空指针异常"),

    // 数据验证相关（500系列）
    MODEL_FAILED_VALIDATION(500, "数据验证不通过"),

    // 操作错误相关（100系列）
    OPERATE_FAILED_DATA_NOT_EXISTS(101, "查询数据不存在！"),
    OPERATE_FAILED_ADD_ERROR(102, "新增数据失败！"),
    OPERATE_FAILED_UPDATE_ERROR(103, "更新数据失败！"),
    OPERATE_FAILED_FILE_NOT_EXISTS(104, "操作失败，文件不存在！"),
    OPERATE_FAILED_FILE_UPLOAD_ERROR(105, "操作失败，文件上传错误！"),
    OPERATE_FAILED_DATA_VERSION_NOT_LATEST(106, "操作失败, 可能当前数据版本不是最新, 请获取最新数据后重试！"),

    // 用户登录相关（200系列）
    USER_LOGIN_FAILED_VALIDATECODE_NOT_EXISTS(201, "验证码不存在！"),
    USER_LOGIN_FAILED_VALIDATECODE_ERROR(202, "验证码错误！"),
    USER_LOGIN_SMS_CODE_OVERTIME(203, "短信验证码已过期！"),
    USER_LOGIN_FAILED_USERID_NOT_EXISTS(204, "登录失败，用户名不存在！"),
    USER_BIND_THIRD_LOGIN_ERROR(205, "登录失败，用户被禁用！"),
    USER_LOGIN_FAILED_USER_DISABLE(206, "登录失败，密码错误！"),
    USER_UPDATE_ERROR(207, "修改用户失败！"),
    USER_MIBILE_NOT_EXIST(208, "该手机号不存在！"),
    USER_NO_CENTERSTAGE_AUTH(209, "账号无会员运营平台使用权限"),
    USER_ACCOUNT_OR_PASSWORD_ERROR(210, "用户名或密码错误"),

    // 网络与系统错误（300系列）
    NETWORK_ERROR(301, "网络异常！"),
    SYSTEM_ERROR(302, "系统内部错误！"),
    SYSTEM_USER_BUSINESS_LIMIT(303, "您请求过于频繁，请稍后重试！"),
    SYSTEM_BUSINESS_LIMIT(304, "当前系统繁忙，请稍后重试！"),

    // 上传相关（400系列）
    UPLOAD_SUCCESS(401, "导入成功！"),
    UPLOAD_FAILED(402, "导入失败！"),

    // 下载相关
    DOWNLOAD_SUCCESS(403, "下载成功！"),
    DOWNLOAD_FAILED(404, "下载失败！"),

    // 短信相关（500系列）
    SMS_CODE_SEND_FAILED(500, "短信验证码发送失败"),
    SMS_CODE_SEND_SUCCESS(501, "短信验证码发送成功"),
    SMS_CODE_VERIFY_FAILED(502, "短信验证码验证失败"),
    SMS_CODE_VERIFY_SUCCESS(503, "短信验证码验证成功"),

    // 参数相关（1000系列）
    PARAM_NULL(1001, "入参为空"),
    PARAM_INVALID(1002, "参数校验失败"),
    PARAM_OUT_OF_RANGE(1003, "参数超出范围"),
    PARAM_FORMAT_ERROR(1004, "参数格式错误"),

    // 会员相关（2000系列）
    MEMBER_NOT_FOUND(2001, "会员不存在"),
    MEMBER_ALREADY_EXISTS(2002, "会员已经存在"),
    MEMBER_INACTIVE(2003, "会员账户已被禁用"),
    MEMBER_PHONE_NUMBER_NOT_EMPTY(2004, "手机号不能为空"),
    MEMBER_REGISTERED(2005, "该会员已注册"),
    MEMBER_WECHAT_ACCOUNT_RELATION_OTHER_PHONE(2006, "该手机号已关联其他微信账户"),
    MEMBER_PHONE_RELATION_OTHER_MEMBER(2007, "该手机号已关联其他会员"),
    MEMBER_REAL_VERIFIED(2008, "该会员已实名认证"),
    MEMBER_LICENSE_PLATE_LIMIT(2009, "会员最多只能添加3个车牌"),
    MEMBER_BLACKLIST(2015, "会员状态异常，如有疑问请联系客服"),
    MEMBER_NOT_FOUND_FLIGHT_RECORD_XD(2020, "三天内未查询到您已通过安检的离港航班记录"),
    MEMBER_ALREADY_GRANTED_INTEGRAL(2025, "该行程已发放过乘机贡献值，感谢您的支持"),
    MEMBER_PROTECT_TIME_GRADING_UP(2030, "会员在保护时间内有升级记录，不允许降级"),
    MEMBER_PROTECT_TIME_GRADING_DOWN(2035, "会员在保护时间内有降级记录，不允许降级"),
    // 优惠券相关（3000系列）
    COUPON_NOT_FOUND(3001, "优惠券不存在"),
    COUPON_NOT_CAN_USE(3002, "优惠券状态不可用（包含已核销、已过期、未到使用期、转赠中）"),
    COUPON_NOT_APPLICABLE(3003, "优惠券不适用于该订单"),
    COUPON_LIMIT_REACHED(3004, "优惠券使用次数达到上限"),
    COUPON_NOT_VALID_CURRENT_MERCHANT(3005, "优惠券不适用于当前商户"),
    COUPON_NOT_BELONG_TO_MEMBER(3006, "优惠券不属于该会员"),
    COUPON_EXTERNAL_NOT_AVAILABLE(3010, "外部券已用完"),
    COUPON_NOT_MEET_MINIMUM_AMOUNT(3007, "订单不满足最低消费金额"),
    COUPON_NOT_MEET_MINIMUM_AMOUNT_FOR_EXTERNAL(3008, "优惠券不满足最低消费金额（外部券）"),
    COUPON_NOT_MEET_MINIMUM_AMOUNT_FOR_EXTERNAL_COUPON(3009, "优惠券不满足最低消费金额（外部券）"),
    COUPON_USED(3015, "优惠券已核销"),
    COUPON_ALREADY_USED(3016, "优惠券已被其他订单核销"),
    COUPON_USE_GOODS_NO_CAN_NULL(3018, "商品不能为空"),
    COUPON_NOT_AVAILABLE_GOODS(3019, "结算订单中无可用商品"),
    COUPON_REVOKED(3020, "优惠券已撤销"),
    COUPON_NOT_MERCHANT_RANGE(3025, "该优惠券不在当前门店核销范围内"),
    COUPON_NOT_VALID_CURRENT_TIME(3030, "优惠券未到有效期"),
    COUPON_DEF_ADD_FAIL_GOODS_VALID_FAIL(3035, "保存失败，数据存在异常"),
    COUPON_NOT_MEET_MINIMUM_DISCOUNT(3040, "订单不满足最低折扣"),
    // 贡献值相关（4000系列）
    POINTS_NOT_FOUND(4001, "贡献值记录不存在"),
    INSUFFICIENT_POINTS(4002, "贡献值不足"),
    POINTS_EXPIRED(4003, "贡献值已过期"),

    // 订单相关（5000系列）
    ORDER_NOT_FOUND(5001, "订单不存在"),
    ORDER_ALREADY_PAID(5002, "订单已经支付"),
    ORDER_CANCELLATION_NOT_ALLOWED(5003, "订单无法取消"),
    ORDER_STATUS_INVALID(5004, "订单状态无效"),

    // 贡献值商城相关（6000系列）
    PRODUCT_NOT_FOUND(6001, "抱歉, 商品不存在"),
    INSUFFICIENT_STOCK(6002, "抱歉, 库存不足"),
    POINTS_REDEMPTION_FAILED(6003, "抱歉, 贡献值兑换失败"),
    POINTS_CONFIG_ALREADY_EXISTS(6004, "抱歉, 贡献值商城配置已存在"),
    SKU_CAN_NOT_BE_NULL_FOR_REAL_GOODS(6005, "抱歉, 贡献值商品为实物时,商品sku不能为空"),
    POINTS_REDEMPTION_FAILED_TO_FIND_PRODUCT_TYPE(6006, "抱歉, 贡献值兑换失败, 找不到商品类型"),
    PRODUCT_TYPE_NOT_FOUND(6007, "抱歉, 商品类型不存在"),
    POINTS_MALL_ORDER_NOT_FOUND(6008, "抱歉, 订单不存在"),
    PRODUCT_NOT_FOUND_IN_ORDER(6009, "抱歉, 订单中不存在该商品"),
    PRODUCT_TYPE_NOT_SUPPORT_REDEMPTION(60010, "抱歉, 商品类型不支持贡献值兑换"),
    POINTS_MALL_ORDER_CANCEL_NOT_ALLOWED(60011, "抱歉, 当前订单不允许取消"),
    POINTS_MALL_ORDER_CANCEL_FAILED(60012, "抱歉, 当前订单取消失败"),
    POINTS_MALL_ORDER_CONFIRM_NOT_ALLOWED(60013, "抱歉, 当前订单不能确认收货"),
    POINTS_MALL_ORDER_CONFIRM_FAILED(60014, "抱歉, 当前订单确认收货失败"),
    POINTS_MALL_NOT_QUALIFIED(60015, "抱歉, 您不符合当前商品兑换条件"),
    POINT_MALL_PAY_INFO_ERROR(60016, "抱歉, 支付信息获取失败, 请稍后再试"),
    POINTS_MALL_ORDER_UPDATE_FAIL(60017, "抱歉, 订单状态修改失败"),
    POINTS_MALL_REFUND_ORDER_NOT_FOUND(60018, "抱歉, 售后订单不存在"),
    POINTS_MALL_REFUND_ORDER_UPDATE_FAIL(60019, "抱歉, 售后订单状态修改失败"),
    POINTS_MALL_CATEGORY_NAME_REPEAT(60020, "抱歉, 商品分类名称不允许重复"),
    POINTS_MALL_PRODUCT_NO_REPEAT(60021, "抱歉, 商品编号不允许重复"),
    POINTS_MALL_PRODUCT_SKU_REPEAT(60022, "抱歉, SKU编号不允许重复"),
    POINTS_MALL_CATEGORY_NO_REPEAT(60023, "抱歉, 商品分类编号不允许重复"),
    EXCEED_LIMIT_EXCHANGE(60024, "抱歉, 兑换商品数量已超个人限制"),
    POINTS_MALL_ORDER_SUCCESS_NOT_ALLOWED(60025, "抱歉, 当前订单不能变更为完成状态"),
    POINTS_MALL_ORDER_POINTS_REDUCE_FAIL(60026, "抱歉, 贡献值兑换失败, 扣减贡献值失败"),
    POINTS_MALL_ORDER_POINTS_RETURN_FAIL(60027, "抱歉, 贡献值返还失败"),
    POINTS_MALL_CONFIG_NOT_FOUND(60028, "抱歉, 贡献值商城配置信息, 无法继续操作"),
    POINTS_MALL_ORDER_STATUS_NOT_ALLOWED_REFUND(60029, "抱歉, 当前订单状态, 不支持售后"),
    POINTS_MALL_ORDER_RECEIVE_TIMEOUT(60030, "抱歉, 当前订单已过售后时间"),
    POINTS_MALL_ORDER_FAIL(60031, "抱歉, 当前订单操作失败, 请稍后再试"),
    POINTS_MALL_REQUEST_TOO_FREQUENTLY(60032, "抱歉, 您当前请求有点频繁, 请稍后重试"),
    POINTS_MALL_PRODUCT_SKU_DISABLED(60033, "抱歉, 当前SKU被禁用, 无法继续操作"),
    POINTS_MALL_ORDER_WAIT_DELIVERY_NOT_ALLOWED(60034, "抱歉, 当前订单状态非待提货状态"),
    POINTS_MALL_ORDER_NOT_SUPPORT_SELF_PICKUP(60035, "抱歉, 当前商品不支持自提"),
    POINTS_MALL_MERCHANT_NOT_SUPPORT_SELF_PICKUP_CURRENT_ORDER (60036, "抱歉, 当前商户无权办理当前订单自提业务"),
    POINTS_MALL_REFUND_INVALID_POINTS(60037, "抱歉, 当前输入实际退款贡献值大于订单实际支付贡献值"),
    POINTS_MALL_REFUND_INVALID_AMOUNT(60038, "抱歉, 当前输入实际退款金额大于订单实际支付金额"),
    POINTS_MALL_REFUND_INVALID_COUPON(60039, "抱歉, 当前优惠券已被核销, 无法退款"),
    POINTS_MALL_REFUND_INVALID_AMOUNT_CURRENT_ORDER(60040, "抱歉, 当前输入的退款数额无效, 无法退款"),
    POINTS_MALL_MERCHANT_NAME_REPEAT(60041, "抱歉, 商户名称不支持重复"),
    POINTS_MALL_MERCHANT_NO_REPEAT(60042, "抱歉, 商户编号不支持重复"),
    POINTS_MALL_MERCHANT_NOT_FOUND(60043, "抱歉, 商户不存在"),
    POINTS_MALL_ORDER_NOT_PAID(60044, "抱歉, 当前订单未完成支付"),
    POINTS_MALL_ORDER_NOT_REFUND(60045, "抱歉, 当前订单未完成退款"),








    // 营销活动相关（7000系列）
    CAMPAIGN_NOT_FOUND(7001, "营销活动不存在"),
    CAMPAIGN_NOT_ACTIVE(7002, "营销活动未开始或已结束"),
    CAMPAIGN_LIMIT_REACHED(7003, "营销活动已达到参与上限"),

    // 营销任务相关（8000系列）
    TASK_NOT_FOUND(8001, "营销任务不存在"),
    TASK_ALREADY_COMPLETED(8002, "营销任务已完成"),
    TASK_NOT_QUALIFIED(8003, "不符合营销任务参与条件"),

    // 营销游戏相关（9000系列）
    GAME_NOT_FOUND(9001, "营销游戏不存在"),
    GAME_NOT_ACTIVE(9002, "营销游戏未开始或已结束"),
    GAME_PARTICIPATION_ERROR(9003, "参与游戏出错"),

    // 中台账号相关（10000系列）
    ACCOUNT_NOT_FOUND(10001, "中台账号不存在"),
    ACCOUNT_ALREADY_EXISTS(10002, "中台账号已经存在"),
    ACCOUNT_INACTIVE(10003, "中台账号已被禁用"),
    MERCHANT_NOT_FOUND(10004, "商户信息不存在"),
    MERCHANT_MATCH_MORE_THAN_ONE(10005, "商户信息匹配多个"),
    STAFF_MATCH_PHONE_EXIST(10006, "员工手机号已存在"),
    STAFF_NO_EXIST(10007, "员工不存在"),
    STAFF_ORDER_NO_EXIST(10008, "员工订单已存在"),
    ORG_NO_EXIST(10009, "组织不存在"),
    DATA_DECYPTION_FAIL(10010, "密文解密失败,请检查数据类型是否正确"),
    STAFF_NO_MODIFY(10011, "总线员工不允许此操作"),
    MERCHANT_NO_PAYMENT_INFO(10012, "当前商户未配置收款信息"),
    MERCHANT_NO_PAYMENT_INFO_CONTACT_SERVICE(10013, "该商户未配置支付信息，请联系客服"),

    // 中台批量任务相关（11000系列）
    BATCH_TASK_NOT_FOUND(11001, "批量任务不存在"),
    BATCH_TASK_ALREADY_RUNNING(11002, "批量任务正在运行"),
    BATCH_TASK_FAILED(11003, "批量任务执行失败"),

    // 内容模块相关
    CONTENT_UPLOAD_FAILED(12001, "腾讯云oss文件上传失败"),
    CONTENT_MATERIAL_BE_RELATED_LABEL(12002, "存在有效素材关联标签,无法删除素材标签"),
    CONTENT_TRACE_NOT_EXIST(12003, "trace未找到"),
    CONTENT_TRACE_TYPE_NOT_EXIST(12004, "traceType不存在"),
    CONTENT_QUESTIONNAIRE_NOT_EXIST(12005, "问卷不存在"),
    CONTENT_QUESTIONNAIRE_IS_NOT_DELIVERY(12006, "问卷非投放中状态"),
    CONTENT_QUESTIONNAIRE_COMMIT_NULL(12007, "问卷提交信息为空"),
    CONTENT_QUESTIONNAIRE_QUESTION_EMPTY(12007, "问卷模板内容为空"),
    CONTENT_CHANNEL_TASK_NOT_EXIST(12008, "渠道任务不存在"),
    CONTENT_CHANNEL_TASK_TEMP_BATCH_NOT_EXIST(12009, "渠道任务临时批次不存在"),
    CONTENT_CHANNEL_TASK_SHORT_TERM_NOT_COMPLIANT(12010, "不处于短期投放时间区间内"),
    CONTENT_TRACE_VALUE_FORMAT_NOT_FIND(12011, "traceValue解析业务参数未找到"),
    CONTENT_MATERIAL_LABEL_EXIST(12012, "素材标签已存在,无法保存更新"),
    CONTENT_URL_CONVERSION_BYTE_FAIL(12013, "文件URL解析失败"),
    CONTENT_AGREEMENT_NOT_EXIST(12014, "协议不存在"),
    CONTENT_CHANNEL_TASK_DETAIL_EXIST(12015, "投放明细名称已存在"),
    CONTENT_QUESTIONNAIRE_COMMIT_EXIST(12016, "已提交过此问卷"),
    CONTENT_QUESTIONNAIRE_CHECK_NOT_PASS(12017, "问卷未审核"),
    CONTENT_CHANNEL_TASK_CHECK_NOT_PASS(12018, "渠道任务未审核"),

    // 消息模块相关
    MESSAGE_MAIL_TEMPLATE_NOT_EXIST(13001, "站内信模板不存在"),
    MESSAGE_MINI_TEMPLATE_NOT_EXIST(13002, "小程序订阅模板不存在"),
    MESSAGE_SMS_TEMPLATE_VERIFY_CODE_NOT_EXIST(13002, "未配置验证码短信模板"),

    MESSAGE_SMS_ALIYUN_INTERFACE_REQUEST_ERROR(13004, "阿里云接口[%s]请求失败:[%s]"),
    MESSAGE_SMS_TEMPLATE_TYPE_NOT_CONFIGURED(13005, "短信模板:[%s]未配置"),
    MESSAGE_SMS_TEMPLATE_TYPE_NOT_ENABLED(13006, "短信模板:[%s]未启用"),
    MESSAGE_SMS_TEMPLATE_MKT_MASS_NOT_EXIST(13007, "群发消息短信模板:[%s]不存在"),
    MESSAGE_MINI_TEMPLATE_TYPE_NOT_CONFIGURED(13008, "小程序订阅模板:[%s]未配置"),
    MESSAGE_MINI_TEMPLATE_TYPE_NOT_ENABLED(13009, "小程序订阅模板:[%s]未启用"),
    MESSAGE_MINI_FIELD_IS_NULL(13010, "小程序订阅模板:[%s]未设置字段信息"),
    MESSAGE_MINI_NOT_HAVE_SUBSCRIBE_RECORD(13011, "未匹配到订阅记录,不发送小程序订阅消息"),

    // rights模块相关
    RIGHTS_HOTEL_CODE_EXISTS(14001, "酒店编码已存在"),
    RIGHTS_HOTEL_ROOM_TYPE_CODE_EXISTS(14002, "酒店房型代码已存在"),
    RIGHTS_HOTEL_ROOM_TYPE_SHELVES(14003, "酒店房型已下架"),
    RIGHTS_HOTEL_ROOM_SITUATION_INSUFFICIENT_STOCK(14004, "酒店房型库存不足"),
    RIGHTS_HOTEL_ORDER_NOT_EXISTS(14005,"酒店订单不存在"),
    RIGHTS_HOTEL_ORDER_MEMBER_NOT_MATCH(14006,"酒店订单会员不一致"),
    RIGHTS_HOTEL_ROOM_SITUATION_INVENTORY_STOCK_FAILED(14007, "扣减库存失败"),
    RIGHTS_HOTEL_ORDER_STATUS_NO_MATCH(14008,"酒店订单状态有误"),
    RIGHTS_HOTEL_NOT_ENABLE(14009,"酒店未启用"),
    RIGHTS_HOTEL_ORDER_WECHAT_PAY_DELAY(14010,"酒店订单微信支付超时"),
    RIGHTS_HOTEL_ORDER_WECHAT_PAY_STATUS_FAIL(14011,"当前订单状态不是待支付"),
    RIGHTS_HOTEL_ORDER_STAFF_DAY_LIMIT(14012,"员工酒店订单已达当日上限"),
    RIGHTS_HOTEL_ORDER_AFTER_LATEST_CANCELLATION_TIME(14013, "当前订单已过最晚取消时间,请联系客服"),
    RIGHTS_HOTEL_ORDER_WECHAT_PAY_FAILED(14014,"当前订单支付方式有误"),
    RIGHTS_STEWARD_ORDER_NOT_EXISTS(14015,"机场管家订单不存在"),
    RIGHTS_STEWARD_SERVICE_SHELVES(14016,"机场管家服务已下架"),
    RIGHTS_STEWARD_ORDER_INVALID_ADDITIONAL_COST(14017,"机场管家订单无效额外费用"),
    RIGHTS_STEWARD_ORDER_MEMBER_NOT_MATCH(14018,"机场管家订单会员不一致"),
    RIGHTS_STEWARD_ORDER_STATUS_NO_MATCH(14019,"机场管家订单状态有误"),
    RIGHTS_STEWARD_SERVICE_NOT_FOUND(14020,"机场管家服务未找到"),
    RIGHTS_STEWARD_ORDER_UPDATE_FAIL(14021,"更新订单失败"),
    RIGHT_STEWARD_ORDER_DETAIL_NOT_FOUND(14022,"机场管家订单详情未找到"),
    RIGHTS_STEWARD_FLIGHT_INFO_NOT_EXISTS(14023,"未查到航班信息"),
    RIGHTS_STEWARD_ORDER_NOT_BELONG_TO_STAFF(14024,"无法核销非本人服务订单"),
    RIGHTS_STEWARD_ORDER_NOT_AUTHORIZED_TO_VIEW (14025,"无法查看非本人预定的订单数据"),
    RIGHTS_HOTEL_NOT_CONFIG_PAYMENT_INFO (14026,"该商户未配置支付信息, 请联系酒店"),





    // 航班信息不存在
    FLIGHT_INFO_NOT_EXISTS(15001,"航班信息不存在"),


    // 支付相关
    PAYMENT_CONFIG_NOT_FOUND(16001,"支付通道配置不存在"),
    PAYMENT_CONFIG_INCOMPLETE(16002,"支付通道配置不完整"),
    PAYMENT_CHANNEL_CALL_FAIL(16003,"调用对应支付通道接口失败"),
    PAYMENT_CHANNEL_PRE_ORDER_CALL_FAIL(16004,"调用对应支付通道预下单接口失败"),
    PAYMENT_CHANNEL_QUERY_ORDER_CALL_FAIL(16005,"调用对应支付通道订单查询接口失败"),
    PAYMENT_CHANNEL_CALL_REFUND_FAIL(16006,"调用对应支付通道退款接口失败"),
    PAYMENT_CHANNEL_CALL_CLOSE_ORDER_FAIL(16007,"调用对应支付通道关闭订单接口失败"),
    PAYMENT_CHANNEL_CALL_QUERY_REFUND_FAIL(16008,"调用对应支付通道查询退款接口失败"),
    PAYMENT_ORDER_NOT_EXIST(16009,"支付系统订单信息不存在"),
    PAYMENT_REFUND_ORDER_NOT_EXIST(16010,"支付系统退单信息不存在"),
    PAYMENT_REFUND_ORDER_EXIST(16011,"支付系统退单信息已存在"),
    PAYMENT_FROZEN_RECORD_STATUS_NOT_FROZEN(16012,"只有冻结状态才可以进行解冻操作"),
    PAYMENT_FROZEN_RECORD_STATUS_NOT_UNSLIPT(16013,"只有待分账状态才可以进行分账操作"),
    PAYMENT_FROZEN_RECORD_NOT_EXIST(16014,"支付系统冻结记录信息不存在"),
    PAYMENT_FROZEN_RECORD_UNFROZEN_FAIL(16015,"调用对应解冻接口失败"),
    PAYMENT_FROZEN_RECORD_SLIPT_FAIL(16016,"调用对应分账接口失败"),


    ;

    private int code;

    private String message;

    SysResponseEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

}

