package com.bizvane.utils.enumutils;

import lombok.Getter;

/**
 * 贡献值商城订单状态
 */
@Getter
public enum IntegralMallRefundOrderStatusEnum {
    //退单状态 1待审核 2待退款 3已退款 4已驳回
    WAIT_AUDIT(1, "待审核"),
    WAIT_REFUND(2, "待退款"),
    REFUNDED(3, "已退款"),
    REJECTED(4, "已驳回");

    private final Integer type;

    private final String typeDes;

    IntegralMallRefundOrderStatusEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
}