package com.bizvane.utils.enumutils;

public enum PaymentFrozenRecordStatusEnum {
    PAY_WAIT(1, "冻结"),
    PAY_SUCCESS(2, "待分账"),
    PAY_CLOSE(3, "已分账");

    private Integer code;
    private String desc;

    PaymentFrozenRecordStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PaymentFrozenRecordStatusEnum getByCode(Integer code) {
        for (PaymentFrozenRecordStatusEnum value : PaymentFrozenRecordStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }


}
