package com.bizvane.utils.enumutils;


public enum IntegralMallPayTypeEnum {
    INTEGRAL_PAY(1, "贡献值支付"),
    WECHAT_PAY(2, "现金支付"),
    INTEGRAL_WECHAT_PAY(3, "贡献值+现金支付");
    private final Integer type;
    private final String typeDes;
    IntegralMallPayTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDescriptionByType(Integer type) {
        for (IntegralMallPayTypeEnum deliveryEnum : IntegralMallPayTypeEnum.values()) {
            if (deliveryEnum.getType().equals(type)) {
                return deliveryEnum.getTypeDes();
            }
        }
        return "无法匹配的类型";
    }
    public Integer getType() {
        return type;
    }
    public String getTypeDes() {
        return typeDes;
    }
}
