/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.responseinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageInfo<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> list = new ArrayList<T>();
    private int pageNum;
    private int pageSize;
    private int pages;
    private long total;

    public PageInfo() {
    }

    public PageInfo(int pageNum, int pageSize, long total, List<T> list) {
        this.list = list;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.pages = (int)Math.ceil((double)total / (double)pageSize);
    }

    public List<T> getList() {
        return this.list;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPages() {
        return this.pages;
    }

    public long getTotal() {
        return this.total;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPages();
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "PageInfo(list=" + String.valueOf(this.getList()) + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", pages=" + this.getPages() + ", total=" + this.getTotal() + ")";
    }
}

