/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.autoconfig.traceController;

import com.alibaba.fastjson.JSON;
import com.bizvane.autoconfig.traceController.TraceControllerProperties;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.HandlerMapping;

@Aspect
public class TraceControllerAspect
implements Ordered {
    public static final int TWO_M = 0x200B20;
    public static final String PUBLIC_BIZVANE_SYS_OPERATION_LOG = "public_bizvane_sys_operation_log";
    public static final String TAG_A = "TagA";
    final String GET_DELETE_ASPECT = "@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping))";
    final String POST_PUT_ASPECT = "@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping))";
    @Autowired
    HttpServletRequest request;
    final Pattern skipPattern;
    final Logger logger;
    final TraceControllerProperties properties;
    final ApplicationContext context;

    public TraceControllerAspect(Pattern skipPattern, TraceControllerProperties properties, ApplicationContext context) {
        this.context = context;
        this.skipPattern = skipPattern;
        this.properties = properties;
        this.logger = LoggerFactory.getLogger((String)Optional.ofNullable(properties).map(TraceControllerProperties::getLoggerName).orElse(this.getClass().getName()));
    }

    @Around(value="@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping))")
    public Object getAndDeleteAround(ProceedingJoinPoint pjp) throws Throwable {
        return this.around("@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping))", pjp);
    }

    @Around(value="@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping))")
    public Object postAndPutAround(ProceedingJoinPoint pjp) throws Throwable {
        return this.around("@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping))", pjp);
    }

    public Object around(String aspect, ProceedingJoinPoint pjp) throws Throwable {
        Log logStart = this.logStart(aspect, pjp);
        this.logger.info(logStart.getOut().toString(), (Object[])logStart.getArgumentsList().stream().toArray(Object[]::new));
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object result = null;
        try {
            Object object = result = pjp.proceed();
            return object;
        }
        catch (Exception e) {
            result = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw e;
        }
        finally {
            Log logEnd = this.logEnd(result, stopwatch);
            long ms = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (this.properties.getSlowThreshold() != null && ms > this.properties.getSlowThreshold().toMillis()) {
                this.logger.error(logEnd.getOut().toString(), (Object[])logEnd.getArgumentsList().stream().toArray(Object[]::new));
            }
            this.logger.info(logEnd.getOut().toString(), (Object[])logEnd.getArgumentsList().stream().toArray(Object[]::new));
        }
    }

    private Log logStart(String aspect, ProceedingJoinPoint pjp) {
        Log log = new Log();
        log.log("Start").logNext(this.request.getMethod()).logNext(this.request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE));
        if (this.properties.isOutRequestQuery() && !Strings.isNullOrEmpty((String)this.request.getQueryString())) {
            log.logNext("query", this.request.getQueryString());
        }
        if ("@within(org.springframework.web.bind.annotation.RestController) && (@annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping))".equals(aspect)) {
            int bodyIndex = this.isUseBody(pjp);
            if (bodyIndex > -1) {
                if (this.properties.isOutRequestBody()) {
                    log.logNext("body", JSON.toJSONString((Object)pjp.getArgs()[bodyIndex]));
                }
            } else if (this.properties.isOutRequestForm()) {
                log.logNext("form", JSON.toJSONString((Object)this.request.getParameterMap()));
            }
        }
        if (this.properties.isOutRequestHeader()) {
            HashMap headersMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(this.properties.getOutRequestHeaderNames())) {
                for (String headerName : this.properties.getOutRequestHeaderNames()) {
                    headersMap.put(headerName, this.request.getHeader(headerName));
                }
            } else {
                Enumeration headerNames = this.request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    headersMap.put(headerName, this.request.getHeader(headerName));
                }
            }
            log.logNext("headers", JSON.toJSONString((Object)headersMap));
        }
        return log;
    }

    private Log logEnd(Object result, Stopwatch stopwatch) {
        Log log = new Log();
        log.log("End").logNext(this.request.getMethod()).logNext(this.request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE));
        stopwatch.stop();
        long us = stopwatch.elapsed(TimeUnit.MICROSECONDS);
        log.logNext("cost", us + " \u03bcs");
        log.logNext(stopwatch);
        if (this.properties.isOutResponseResult()) {
            String resultStr = JSON.toJSONString((Object)result);
            if (this.properties.getOutResponseMaxLength() <= 0 || resultStr.length() > this.properties.getOutResponseMaxLength()) {
                // empty if block
            }
            log.logNext("result", resultStr);
        }
        return log;
    }

    private int isUseBody(ProceedingJoinPoint pjp) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] annotationArray;
            for (Annotation annotation : annotationArray = annotations[i]) {
                if (!annotation.annotationType().isAssignableFrom(RequestBody.class)) continue;
                return i;
            }
        }
        return -1;
    }

    public String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
    }

    public static byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static class Log {
        private StringBuilder out = new StringBuilder();
        private List<Object> argumentsList = Lists.newArrayList();

        Log() {
        }

        public Log logNext(Object val) {
            this.out.append(" | {}");
            this.argumentsList.add(val);
            return this;
        }

        public Log log(String describe) {
            this.out.append("{}");
            this.argumentsList.add(describe);
            return this;
        }

        public Log logNext(String describe, Object val) {
            this.out.append(" | {}: {}");
            this.argumentsList.add(describe);
            this.argumentsList.add(val);
            return this;
        }

        public StringBuilder getOut() {
            return this.out;
        }

        public void setOut(StringBuilder out) {
            this.out = out;
        }

        public List<Object> getArgumentsList() {
            return this.argumentsList;
        }

        public void setArgumentsList(List<Object> argumentsList) {
            this.argumentsList = argumentsList;
        }
    }
}

