/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualThreadUtil {
    private static final Logger logger = LoggerFactory.getLogger(VirtualThreadUtil.class);
    private static final ExecutorService virtualThreadExecutor = VirtualThreadUtil.createVirtualThreadExecutor();

    private static ExecutorService createVirtualThreadExecutor() {
        try {
            return Executors.newVirtualThreadPerTaskExecutor();
        }
        catch (Exception e) {
            logger.warn("\u865a\u62df\u7ebf\u7a0b\u4e0d\u652f\u6301\u5f53\u524dJava\u7248\u672c\uff0c\u56de\u9000\u5230\u5e73\u53f0\u7ebf\u7a0b: {}", (Object)e.getMessage());
            return Executors.newCachedThreadPool(r -> {
                Thread thread = new Thread(r);
                thread.setUncaughtExceptionHandler((t, er) -> logger.error("\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38: {}", (Object)t.getName(), (Object)er));
                return thread;
            });
        }
    }

    public static void runAsync(Runnable task) {
        virtualThreadExecutor.submit(task);
    }

    public static <T> Future<T> callableAsync(Callable<T> task) {
        return virtualThreadExecutor.submit(task);
    }

    public static Thread startVirtualThread(Runnable task) {
        try {
            return Thread.ofVirtual().start(task);
        }
        catch (UnsupportedOperationException e) {
            logger.warn("\u865a\u62df\u7ebf\u7a0b\u4e0d\u652f\u6301\u5f53\u524dJava\u7248\u672c\uff0c\u56de\u9000\u5230\u5e73\u53f0\u7ebf\u7a0b: {}", (Object)e.getMessage());
            Thread platformThread = new Thread(task);
            platformThread.start();
            return platformThread;
        }
    }

    public static void shutdown() {
        if (virtualThreadExecutor != null && !virtualThreadExecutor.isShutdown()) {
            virtualThreadExecutor.shutdown();
            try {
                if (!virtualThreadExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    virtualThreadExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                virtualThreadExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static ExecutorService getVirtualThreadExecutor() {
        return virtualThreadExecutor;
    }
}

