//
//package com.bizvane.utils.aop;
//
//import org.slf4j.Logger;
//import org.aspectj.lang.ProceedingJoinPoint;
//import org.aspectj.lang.Signature;
//import org.aspectj.lang.annotation.Around;
//import org.aspectj.lang.annotation.Aspect;
//import org.aspectj.lang.annotation.Pointcut;
//import org.aspectj.lang.reflect.MethodSignature;
//import org.slf4j.LoggerFactory;
//import org.springframework.stereotype.Component;
//
//import com.bizvane.utils.enumutils.SysResponseEnum;
//import com.bizvane.utils.exception.BizException;
//import com.bizvane.utils.responseinfo.ResponseData;
//
///**
// * 服务切面 1：处理参数校 2：处理异常信
// *
// * @author
// */
//@Aspect
//@Component
//public class ServiceHandleAspect {
//
//  @Pointcut("execution(* com.bizvane.*.controllers..*.*(..))")
//  public void controllersMethod(){}
//
//  @Pointcut("execution(* com.bizvane.*.service..*.*(..))")
//  public void serviceMethod(){}
//
//  private static Logger logger = LoggerFactory.getLogger(ServiceHandleAspect.class);
//
//  @Around("controllersMethod() || serviceMethod()")
//  @SuppressWarnings("unchecked")
//  public Object checkAndExceptionHandle(ProceedingJoinPoint pjp) throws Throwable {
//    Signature signature = pjp.getSignature();
//    Class<?> returnType = ((MethodSignature) signature).getReturnType();
//    if (!returnType.isAssignableFrom(ResponseData.class)) {
//      return pjp.proceed();
//    }
//    ResponseData<Object> result = new ResponseData<>();
//    try {
//      result = (ResponseData<Object>) pjp.proceed();
//      if (result.getCode() == SysResponseEnum.SUCCESS.getCode()) {
//        result.setCode(SysResponseEnum.SUCCESS.getCode());
//        result.setMessage(SysResponseEnum.SUCCESS.getMessage());
//      }
//    } catch (Exception e) {
//      ServiceHandleAspect.logger.error("ERROR::", e);
//      dealException(result, e);
//    }
//    return result;
//  }
//
//  private void dealException(ResponseData<Object> result, Exception e) {
//    if (e instanceof BizException) {
//      result.setCode(((BizException) e).getCode());
//      result.setMessage(((BizException) e).getMessage());
//      ServiceHandleAspect.logger.error("BusinessException:" + ((BizException) e).getCode());
//    } else if (e instanceof NullPointerException) {
//      result.setCode(SysResponseEnum.NULLPOINTEREXCEPTION.getCode());
//      result.setMessage(SysResponseEnum.NULLPOINTEREXCEPTION.getMessage());
//    } else {
//      result.setCode(SysResponseEnum.FAILED.getCode());
//      result.setMessage(SysResponseEnum.FAILED.getMessage());
//    }
//  }
//}
