/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.cdp.idmapping.service.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.cdp.facade.feign.TCdpCustomerSignFeign;
import com.bizvane.cdp.facade.feign.TCdpCustomerSignMergeRuleFeign;
import com.bizvane.cdp.facade.model.req.QueryCustomerSignListReqVO;
import com.bizvane.cdp.facade.model.rsp.QueryCustomerSignListRespVO;
import com.bizvane.cdp.facade.model.rsp.QueryCustomerSignMergeRuleRespVO;
import com.bizvane.cdp.idmapping.facade.vo.req.EventUploadReqVO;
import com.bizvane.cdp.idmapping.service.domain.po.TCdpMembers1;
import com.bizvane.cdp.idmapping.service.domain.po.TCdpMembersMergeRecord1;
import com.bizvane.cdp.idmapping.service.service.CdpIdMappingService;
import com.bizvane.cdp.idmapping.service.service.ITCdpMembers1Service;
import com.bizvane.cdp.idmapping.service.service.ITCdpMembersMergeRecord1Service;
import com.bizvane.cdp.idmapping.service.util.ResponseUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;

@Service
public class CdpIdMappingServiceImpl
implements CdpIdMappingService {
    private static final Logger log = LoggerFactory.getLogger(CdpIdMappingServiceImpl.class);
    @Autowired
    private ITCdpMembersMergeRecord1Service iTCdpMembersMergeRecord1Service;
    @Autowired
    private ITCdpMembers1Service iTCdpMembers1Service;
    @Autowired
    private TCdpCustomerSignFeign tCdpCustomerSignFeign;
    @Autowired
    private TCdpCustomerSignMergeRuleFeign tCdpCustomerSignMergeRuleFeign;
    @Autowired
    private KafkaTemplate<String, EventUploadReqVO> kafkaTemplate;

    @Override
    public ResponseData<String> customerEventUpload(EventUploadReqVO reqVO) {
        log.info("customerEventUpload reqVO: {}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        ListenableFuture sendKafka = this.kafkaTemplate.send("id_mapping_customer_event_topic", (Object)reqVO);
        log.info("customerEventUpload sendKafka: {}", (Object)JacksonUtil.bean2Json((Object)sendKafka));
        return ResponseUtil.getSuccessData("success");
    }

    @Override
    public void idMappingProcess(EventUploadReqVO reqVO) {
        Long sysCompanyId = reqVO.getSysCompanyId();
        Long sysBrandId = reqVO.getSysBrandId();
        List signParamNameList = reqVO.getSignParamNameList();
        String eventName = reqVO.getEventName();
        Map eventJson = reqVO.getEventJson();
        ArrayList cdpSignParamList = new ArrayList();
        ResponseData signListData = this.tCdpCustomerSignFeign.getList(new QueryCustomerSignListReqVO());
        log.info("signListData: {}", (Object)JacksonUtil.bean2Json((Object)signListData));
        if (signListData.getCode() == SysResponseEnum.SUCCESS.getCode() && CollectionUtil.isNotEmpty((Collection)((Collection)signListData.getData()))) {
            List signNameList = ((List)signListData.getData()).stream().map(QueryCustomerSignListRespVO::getSignName).collect(Collectors.toList());
            cdpSignParamList.addAll(signNameList);
        }
        List<String> eventSignIdList = cdpSignParamList.stream().filter(signParamNameList::contains).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(eventSignIdList)) {
            return;
        }
        LambdaQueryWrapper queryMergeWrapper = new LambdaQueryWrapper();
        queryMergeWrapper.eq(TCdpMembersMergeRecord1::getValid, (Object)1);
        eventSignIdList.forEach(eventSignId -> queryMergeWrapper.or(wrapper -> ((LambdaQueryWrapper)wrapper.eq(TCdpMembersMergeRecord1::getSignColumnName, eventSignId)).eq(TCdpMembersMergeRecord1::getSignColumnValue, eventJson.get(eventSignId))));
        List mergeRecordList = this.iTCdpMembersMergeRecord1Service.list((Wrapper)queryMergeWrapper);
        log.info("mergeRecordList: {}", (Object)JacksonUtil.list2Json((List)mergeRecordList));
        if (CollectionUtil.isEmpty((Collection)mergeRecordList)) {
            this.newSignEvent(eventJson, sysCompanyId, sysBrandId, eventSignIdList);
        } else {
            if (CollectionUtil.size((Object)mergeRecordList) == CollectionUtil.size(eventSignIdList) && mergeRecordList.stream().map(TCdpMembersMergeRecord1::getNewBizOneId).distinct().count() == 1L) {
                return;
            }
            ResponseData mergeRuleByBrandIdData = this.tCdpCustomerSignMergeRuleFeign.getMergeRuleByBrandId(sysCompanyId, sysBrandId);
            log.info("mergeRuleByBrandIdData: {}", (Object)JacksonUtil.bean2Json((Object)mergeRuleByBrandIdData));
            Integer mergeStrategy = 1;
            if (mergeRuleByBrandIdData.getCode() == SysResponseEnum.SUCCESS.getCode() && mergeRuleByBrandIdData.getData() != null) {
                mergeStrategy = ((QueryCustomerSignMergeRuleRespVO)mergeRuleByBrandIdData.getData()).getMergeType();
            }
            List oneIdList = mergeRecordList.stream().map(TCdpMembersMergeRecord1::getNewBizOneId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryMemberWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryMemberWrapper.in(TCdpMembers1::getBizOneId, oneIdList)).eq(TCdpMembers1::getMergeStatus, (Object)1);
            List tCdpMembersList = this.iTCdpMembers1Service.list((Wrapper)queryMemberWrapper);
            log.info("tCdpMembersList: {}", (Object)JacksonUtil.list2Json((List)tCdpMembersList));
            if (ObjectUtil.equal((Object)mergeStrategy, (Object)1)) {
                tCdpMembersList.sort(Comparator.comparing(TCdpMembers1::getCDate));
            } else {
                tCdpMembersList.sort((o1, o2) -> o2.getCDate().compareTo(o1.getCDate()));
            }
            String firstBizOneId = null;
            for (TCdpMembers1 tCdpMembers1 : tCdpMembersList) {
                if (StrUtil.isNotEmpty(firstBizOneId)) break;
                firstBizOneId = CdpIdMappingServiceImpl.getEventBizOneId(tCdpMembers1, eventSignIdList, eventJson);
            }
            if (StrUtil.isEmpty(firstBizOneId)) {
                this.newSignEvent(eventJson, sysCompanyId, sysBrandId, eventSignIdList);
            } else {
                this.mergeSignEvent(eventJson, eventSignIdList, firstBizOneId);
            }
            if (ObjectUtil.equal((Object)mergeStrategy, (Object)1)) {
                tCdpMembersList.sort((o1, o2) -> o2.getCDate().compareTo(o1.getCDate()));
            } else {
                tCdpMembersList.sort(Comparator.comparing(TCdpMembers1::getCDate));
            }
            for (int i = 0; i < tCdpMembersList.size(); ++i) {
                TCdpMembers1 tCdpMembers1;
                tCdpMembers1 = (TCdpMembers1)tCdpMembersList.get(i);
                for (int j = i + 1; j < tCdpMembersList.size(); ++j) {
                    TCdpMembers1 tCdpMembers2 = (TCdpMembers1)tCdpMembersList.get(j);
                    Boolean mergeState = CdpIdMappingServiceImpl.checkMerge(eventSignIdList, tCdpMembers1, tCdpMembers2);
                    if (!ObjectUtil.equal((Object)mergeState, (Object)true)) continue;
                    this.doMerge(tCdpMembers1, eventSignIdList, tCdpMembers2);
                }
            }
        }
    }

    private void doMerge(TCdpMembers1 tCdpMembers1, List<String> eventSignIdList, TCdpMembers1 tCdpMembers2) {
        tCdpMembers1.setMergeStatus(2);
        this.iTCdpMembers1Service.updateById(tCdpMembers1);
        for (String signId : eventSignIdList) {
            String fieldValue1 = (String)ReflectUtil.getFieldValue((Object)tCdpMembers1, (String)signId);
            String fieldValue2 = (String)ReflectUtil.getFieldValue((Object)tCdpMembers2, (String)signId);
            if (!StrUtil.isEmpty((CharSequence)fieldValue2) || !StrUtil.isNotEmpty((CharSequence)fieldValue1)) continue;
            ReflectUtil.setFieldValue((Object)tCdpMembers2, (String)signId, (Object)fieldValue1);
        }
        this.saveOrUpdateMergeRecord(eventSignIdList, JacksonUtil.bean2Map1((Object)tCdpMembers1), tCdpMembers2.getBizOneId());
        this.saveOrUpdateMergeRecord(eventSignIdList, JacksonUtil.bean2Map1((Object)tCdpMembers2), tCdpMembers2.getBizOneId());
        this.notifyCdpService(tCdpMembers1.getBizOneId(), tCdpMembers2.getBizOneId());
        this.iTCdpMembers1Service.updateById(tCdpMembers1);
        this.iTCdpMembers1Service.updateById(tCdpMembers2);
    }

    private static String getEventBizOneId(TCdpMembers1 tCdpMembers1, List<String> eventSignIdList, Map<String, String> eventJson) {
        String firstBizOneId = null;
        for (String signId : eventSignIdList) {
            String fieldValue = (String)ReflectUtil.getFieldValue((Object)tCdpMembers1, (String)signId);
            String eventFieldValue = eventJson.get(signId);
            if (StrUtil.isEmpty((CharSequence)fieldValue) || StrUtil.isEmpty((CharSequence)eventFieldValue)) continue;
            if (!ObjectUtil.equal((Object)fieldValue, (Object)eventFieldValue)) break;
            firstBizOneId = tCdpMembers1.getBizOneId();
            break;
        }
        return firstBizOneId;
    }

    private static Boolean checkMerge(List<String> eventSignIdList, TCdpMembers1 tCdpMembers1, TCdpMembers1 tCdpMembers2) {
        Boolean mergeState = null;
        for (String signId : eventSignIdList) {
            String fieldValue1 = (String)ReflectUtil.getFieldValue((Object)tCdpMembers1, (String)signId);
            String fieldValue2 = (String)ReflectUtil.getFieldValue((Object)tCdpMembers2, (String)signId);
            if (StrUtil.isEmpty((CharSequence)fieldValue1) || StrUtil.isEmpty((CharSequence)fieldValue2)) continue;
            if (ObjectUtil.equal((Object)fieldValue1, (Object)fieldValue2)) {
                mergeState = false;
                break;
            }
            mergeState = true;
            break;
        }
        return mergeState;
    }

    private void newSignEvent(Map<String, String> eventJson, Long sysCompanyId, Long sysBrandId, List<String> eventSignIdList) {
        String snowflakeNextIdStr = IdUtil.getSnowflakeNextIdStr();
        TCdpMembers1 tcdpMembers1 = new TCdpMembers1();
        tcdpMembers1.setSysCompanyId(sysCompanyId);
        tcdpMembers1.setSysBrandId(sysBrandId);
        tcdpMembers1.setBizOneId(snowflakeNextIdStr);
        tcdpMembers1.setCDate(LocalDateTime.now());
        tcdpMembers1.setCreateDate(LocalDateTime.now());
        tcdpMembers1.setMergeStatus(1);
        this.saveOrUpdateMergeRecord(eventSignIdList, eventJson, snowflakeNextIdStr);
        for (String signId : eventSignIdList) {
            String signValue = eventJson.get(signId);
            if (StrUtil.isEmpty((CharSequence)signValue)) continue;
            try {
                ReflectUtil.setFieldValue((Object)tcdpMembers1, (String)signId, (Object)signValue);
            }
            catch (UtilException e) {
                throw new RuntimeException(e);
            }
        }
        this.iTCdpMembers1Service.save(tcdpMembers1);
        this.mergeBizOneIdToEventJson(eventJson, snowflakeNextIdStr);
    }

    private void mergeSignEvent(Map<String, String> eventJson, List<String> eventSignIdList, String firstBizOneId) {
        this.saveOrUpdateMergeRecord(eventSignIdList, eventJson, firstBizOneId);
        this.mergeBizOneIdToEventJson(eventJson, firstBizOneId);
    }

    private void saveOrUpdateMergeRecord(List<String> eventSignIdList, Map<String, String> eventJson, String bizOneId) {
        ArrayList<TCdpMembersMergeRecord1> addRecordList = new ArrayList<TCdpMembersMergeRecord1>();
        for (String signId : eventSignIdList) {
            String signValue = eventJson.get(signId);
            if (StrUtil.isEmpty((CharSequence)signValue)) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TCdpMembersMergeRecord1::getSignColumnName, (Object)signId)).eq(TCdpMembersMergeRecord1::getSignColumnValue, (Object)signValue)).eq(TCdpMembersMergeRecord1::getValid, (Object)1);
            TCdpMembersMergeRecord1 mergeRecord = (TCdpMembersMergeRecord1)this.iTCdpMembersMergeRecord1Service.getOne((Wrapper)queryWrapper);
            if (mergeRecord != null) {
                mergeRecord.setOldBizOneId(mergeRecord.getNewBizOneId());
                mergeRecord.setNewBizOneId(bizOneId);
                continue;
            }
            mergeRecord = new TCdpMembersMergeRecord1();
            mergeRecord.setNewBizOneId(bizOneId);
            mergeRecord.setOldBizOneId(bizOneId);
            mergeRecord.setSignColumnName(signId);
            mergeRecord.setSignColumnValue(signValue);
            mergeRecord.setValid(1);
            addRecordList.add(mergeRecord);
        }
        if (CollectionUtil.isNotEmpty(addRecordList)) {
            this.iTCdpMembersMergeRecord1Service.saveBatch(addRecordList);
        }
    }

    private void mergeBizOneIdToEventJson(Map<String, String> eventJson, String bizOneId) {
        eventJson.put("bizOneId", bizOneId);
    }

    private void notifyCdpService(String oldBizOneId, String newBizOneId) {
    }
}

