/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.cdp.idmapping.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.cdp.idmapping.facade.vo.req.CdpCustomerInfoUpdateReqVO;
import com.bizvane.cdp.idmapping.service.domain.po.TCdpMembers1;
import com.bizvane.cdp.idmapping.service.service.CdpCustomerInfoUpdateService;
import com.bizvane.cdp.idmapping.service.service.ITCdpMembers1Service;
import com.bizvane.cdp.idmapping.service.util.ResponseUtil;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;

@Service
public class CdpCustomerInfoUpdateServiceImpl
implements CdpCustomerInfoUpdateService {
    private static final Logger log = LoggerFactory.getLogger(CdpCustomerInfoUpdateServiceImpl.class);
    @Autowired
    private ITCdpMembers1Service itCdpMembers1Service;
    @Autowired
    private KafkaTemplate<String, CdpCustomerInfoUpdateReqVO> kafkaTemplate;

    @Override
    public ResponseData<String> updateCustomerInfo(CdpCustomerInfoUpdateReqVO reqVO) {
        log.info("updateCustomerInfo reqVO: {}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        ListenableFuture sendKafka = this.kafkaTemplate.send("id_mapping_customer_info_topic", (Object)reqVO);
        log.info("sendKafka: {}", (Object)JacksonUtil.bean2Json((Object)sendKafka));
        return ResponseUtil.getSuccessData("\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\u6210\u529f");
    }

    @Override
    public void updateCustomerInfoProcess(CdpCustomerInfoUpdateReqVO reqVO) {
        TCdpMembers1 tCdpMembers1 = (TCdpMembers1)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)reqVO), TCdpMembers1.class);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(TCdpMembers1::getBizOneId, (Object)reqVO.getBizOneId());
        this.itCdpMembers1Service.update(tCdpMembers1, (Wrapper)lambdaQueryWrapper);
    }
}

