/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.cdp.idmapping.service.config;

import com.bizvane.cdp.idmapping.facade.vo.req.CdpCustomerInfoUpdateReqVO;
import com.bizvane.cdp.idmapping.facade.vo.req.EventUploadReqVO;
import com.bizvane.cdp.idmapping.service.service.CdpCustomerInfoUpdateService;
import com.bizvane.cdp.idmapping.service.service.CdpIdMappingService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.KafkaListener;

@Configuration
public class KafkaListenerConfig {
    private static final Logger log = LoggerFactory.getLogger(KafkaListenerConfig.class);
    @Autowired
    private CdpIdMappingService cdpIdMappingService;
    @Autowired
    private CdpCustomerInfoUpdateService cdpCustomerInfoUpdateService;

    @KafkaListener(topics={"id_mapping_customer_event_topic"}, groupId="cdp_id_mapping_group")
    public void eventUploadListener(EventUploadReqVO reqVO) {
        log.info("eventUploadListener Received message: {}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        this.cdpIdMappingService.idMappingProcess(reqVO);
    }

    @KafkaListener(topics={"id_mapping_customer_info_topic"}, groupId="cdp_id_mapping_group")
    public void customerInfoListener(CdpCustomerInfoUpdateReqVO reqVO) {
        log.info("customerInfoListener Received message: {}", (Object)JacksonUtil.bean2Json((Object)reqVO));
        this.cdpCustomerInfoUpdateService.updateCustomerInfoProcess(reqVO);
    }
}

