package com.bizvane.cdp.idmapping.facade.feign;

import com.bizvane.cdp.idmapping.facade.vo.req.CdpImportAddCustomerReqVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(value = "${feign.client.cdp-id-mapping.name}", path = "${feign.client.cdp-id-mapping.path}" + "/cdpImportAddCustomer")
@Api(value = "客户导入新增")
public interface CdpImportAddCustomerFeign {

    @PostMapping("/importAdd")
    ResponseData<String> importAdd(@RequestBody CdpImportAddCustomerReqVO reqVO);


}
