package com.bizvane.facade.model.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
public class CustomerLabelAndGroupCalculateResultDetailCallbackReqVO {

    @ApiModelProperty(value = "计算任务关联ID")
    @NotNull(message = "任务关联ID不能为空")
    private Integer calculateTaskRelationId;

    @ApiModelProperty(value = "计算规则集")
    private List<String> calculateRuleList;

    @ApiModelProperty(value = "覆盖用户数")
    private Integer coveredUserNum;

    @ApiModelProperty(value = "覆盖用户占比")
    private String coveredUserProportion;

    @ApiModelProperty(value = "分群人数")
    private Integer groupUserNum;

    @ApiModelProperty(value = "执行状态（1等待计算，2计算中 3计算成功 4计算失败） ")
    private Integer executeStatus;
}
