package com.bizvane.facade.model.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
public class CustomerLabelAndGroupCalculateResultCallbackReqVO {


    @ApiModelProperty(value = "批次号")
    @NotBlank(message = "批次号不能为空")
    private String batchNumber;

    @ApiModelProperty(value = "计算任务类型(1客户标签 2客户分群)")
    @NotNull(message = "任务类型不能为空")
    private Integer calculateTskType;

    @ApiModelProperty(value = "计算结果明细集合")
    @NotEmpty(message = "计算结果不能为空")
    @Valid
    private List<CustomerLabelAndGroupCalculateResultDetailCallbackReqVO> calculateResultList;

}
