package com.bizvane.facade.feign;


import com.bizvane.facade.model.req.CustomerLabelAndGroupCalculateResultCallbackReqVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.cdp-admin.name}", path = "${feign.client.cdp-admin.path}"+"/customerCalculateResultCallback")
@Api(value = "计算结果回调")
public interface CdpCustomerLabelAndGroupCalculateResultCallbackRpcApi {

    @RequestMapping(value = "/callback", method = RequestMethod.POST)
    ResponseData<Boolean> customerLabelAndGroupCalculateCallback(@RequestBody @Validated CustomerLabelAndGroupCalculateResultCallbackReqVO request);

}
