package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author baofeng@zhidemai.com
 * @createTime 2024-04-09 10:53:11
 * @description: 保存从营销某个节点进入的人群至客户分群
 */

@Api(value = "保存从营销某个节点进入的人群至客户分群")
@Data
public class CdpCustomerGroupSaveRequestVO {

    @ApiModelProperty(value = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌ID")
    private Long sysBrandId;

    @ApiModelProperty(value = "客户分群PKID")
    private Long customerGroupId;

    @ApiModelProperty(value = "分群ID")
    private String groupId;

    @ApiModelProperty(value = "批次号")
    private String batchId;

    @ApiModelProperty(value = "分群运行记录更新方式：1-手动更新 2-周期更新 3-导入更新 4结果保存；定义见cdp服务枚举类CustomerCalculateUpdateWayEnum")
    private Integer updateWay;

    @ApiModelProperty(value = "唯一身份IDList")
    private List<String> bizOneIdList;

}