package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class CdpAlgorithmExecuteLabelRequest {

    public CdpAlgorithmExecuteLabelRequest(Long sysCompanyId, Long sysBrandId, String labelId, List<LabelValue> labelValueList, String batchId, Integer updateWay) {
        this.sysCompanyId = sysCompanyId;
        this.sysBrandId = sysBrandId;
        this.labelId = labelId;
        this.labelValueList = labelValueList;
        this.batchId = batchId;
        this.updateWay = updateWay;
    }

    public CdpAlgorithmExecuteLabelRequest() {
    }

    private Long sysCompanyId;
    private Long sysBrandId;
    private String labelId;
    private List<LabelValue> labelValueList;
    private String batchId;
    @ApiModelProperty(value = "标签计算更新方式：1-周期更新 2-手动更新 3-导入更新")
    private Integer updateWay;

    @ApiModelProperty(value = "系统账号ID")
    private Long sysAccountId;

    private Long crmLabelGroupDefId;

    @Data
    public static class LabelValue {
        private String labelValueId;
        private String rule;
        private Long crmLabelDefId;

        public LabelValue(String labelValueId, String rule) {
            this.labelValueId = labelValueId;
            this.rule = rule;
        }

        public LabelValue() {
        }
    }

}
