package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpMarketingReachRecordSaveReqVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}")
@Api(value = "CDP自动营销触达记录", tags = {"CDP自动营销触达记录"})
public interface CdpMarketingReachRecordFeign {

    @ApiOperation(value = "记录保存(支持批量)")
    @RequestMapping(value = "marketingReach/saveRecord", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Integer> saveRecord(@RequestParam(value = "sysCompanyId") Long sysCompanyId, @RequestBody List<CdpMarketingReachRecordSaveReqVo> request);

}
