package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "CdpCustomerImportLabelRequestVO", description = "客户标签导入对象")
public class CdpCustomerImportLabelRequestVO {

    @ApiModelProperty(value = "企业ID")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌ID")
    private Long sysBrandId;

    @ApiModelProperty(value = "客户标签ID")
    private String labelId;

    @ApiModelProperty(value = "客户标签导入列表")
    private List<CustomerLabelRuleInfo> customerLabelRuleInfoList;


    @Data
    public static class CustomerLabelRuleInfo {

        @ApiModelProperty(value = "客户身份id")
        private String signId;

        @ApiModelProperty(value = "客户身份id值")
        private String signIdValue;

        @ApiModelProperty(value = "规则ID")
        private String ruleId;

        @ApiModelProperty(value = "规则名称")
        private String ruleName;

        @ApiModelProperty(value = "创建时间")
        private Date createDate;

        @ApiModelProperty(value = "数据有效性")
        private Integer valid;

    }

}
