package com.bizvane.cdp.algorithm.facade.interfaces;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpCustomerImportLabelDelRequestVO;
import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpCustomerImportLabelRequestVO;
import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpCustomerLabelDetailReqVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}/cdpCustomerLabelDetail")
@Api(value = "客户标签圈选人群详情", tags = {"客户标签圈选人群详情"})
public interface CdpCustomerLabelDetailFeign {

    @PostMapping("/getCustomerLabelDetailByLabelId")
    ResponseData<Page<Map<String, Object>>> getCustomerLabelDetailByLabelId(@RequestBody CdpCustomerLabelDetailReqVO reqVO);

    @PostMapping("/saveImportLabelRecord")
    ResponseData<Boolean> saveImportLabelRecord(@RequestBody CdpCustomerImportLabelRequestVO reqVO);

    @PostMapping("/deleteLabelImportByLabelId")
    ResponseData<Boolean> deleteLabelImportByLabelId(@RequestBody CdpCustomerImportLabelDelRequestVO reqVO);


}
