package com.bizvane.cdp.algorithm.facade.interfaces.model;

import lombok.Data;

import java.util.List;

@Data
public class CdpAlgorithmExecuteLabelRequest {

    public CdpAlgorithmExecuteLabelRequest(Long sysCompanyId, Long sysBrandId, String labelId, List<LabelValue> labelValueList, String batchId) {
        this.sysCompanyId = sysCompanyId;
        this.sysBrandId = sysBrandId;
        this.labelId = labelId;
        this.labelValueList = labelValueList;
        this.batchId = batchId;
    }

    public CdpAlgorithmExecuteLabelRequest() {
    }

    private Long sysCompanyId;
    private Long sysBrandId;
    private String labelId;
    private List<LabelValue> labelValueList;
    private String batchId;

    @Data
    public static class LabelValue {
        private String labelValueId;
        private String rule;

        public LabelValue(String labelValueId, String rule) {
            this.labelValueId = labelValueId;
            this.rule = rule;
        }

        public LabelValue() {
        }
    }

}
