package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpAlgorithmExecuteGroupRequest;
import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpAlgorithmExecuteLabelRequest;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}")
@Api(value = "执行计算任务", tags = {"执行计算任务"})
public interface CdpAlgorithmExecuteFeign {

    @ApiOperation(value = "计算标签")
    @RequestMapping(value = "execute/label", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeLabel(@RequestBody CdpAlgorithmExecuteLabelRequest request);

    @ApiOperation(value = "计算人群")
    @RequestMapping(value = "execute/group", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeGroup(@RequestBody CdpAlgorithmExecuteGroupRequest request);

}
