/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils.api;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.api.dto.ApiBasicTokenDTO;
import com.wmeimob.fastboot.bizvane.constants.api.ApiConstants;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class BasicTokenUtils {
    private static final Logger log = LoggerFactory.getLogger(BasicTokenUtils.class);
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    public String encode(String key, String content) {
        try {
            byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec key2 = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, key2);
            byte[] encodeResult = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            return this.parseByte2HexStr(encodeResult);
        }
        catch (Exception e) {
            log.warn("BasicTokenUtils#encode\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public String decryptByKeyWithContent(String key, String content) {
        try {
            byte[] raw = key.getBytes("utf-8");
            SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, keySpec);
            byte[] contentByte = this.parseHexTokenStr2Byte(content);
            byte[] decodeResult = cipher.doFinal(contentByte);
            String result = new String(decodeResult, "utf-8");
            log.info("\u89e3\u5bc6\u540e\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)result);
            return result;
        }
        catch (Exception e) {
            log.warn("BasicTokenUtils#decrypt\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public byte[] parseHexTokenStr2Byte(String hexTokenStr) {
        try {
            if (hexTokenStr.length() < 1) {
                return null;
            }
            byte[] result = new byte[hexTokenStr.length() / 2];
            for (int i = 0; i < hexTokenStr.length() / 2; ++i) {
                int high = Integer.parseInt(hexTokenStr.substring(i * 2, i * 2 + 1), 16);
                int low = Integer.parseInt(hexTokenStr.substring(i * 2 + 1, i * 2 + 2), 16);
                result[i] = (byte)(high * 16 + low);
            }
            return result;
        }
        catch (Exception e) {
            log.warn("BasicTokenUtils#parseHexTokenStr2Byte\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public String parseByte2HexStr(byte[] buf) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (byte b : buf) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                stringBuilder.append(hex.toUpperCase());
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            log.warn("BasicTokenUtils#parseByte2HexStr\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public String validateToken(String key, String token) {
        try {
            String decrypt = this.decryptByKeyWithContent(key, token);
            StringBuilder tokenErrorMsg = new StringBuilder("Invalid token! ");
            if (StringUtils.isEmpty((Object)decrypt) || !decrypt.contains(",")) {
                return tokenErrorMsg.toString();
            }
            String merchantId = decrypt.split(",")[0];
            String key361 = decrypt.split(",")[1];
            if (StringUtils.isEmpty((Object)merchantId)) {
                return tokenErrorMsg.append("\u4f60\u7684\u52a0\u5bc6\u683c\u5f0f\u6709\u8bef001").toString();
            }
            if (StringUtils.isEmpty((Object)key361)) {
                return tokenErrorMsg.append("\u4f60\u7684\u52a0\u5bc6\u683c\u5f0f\u6709\u8bef002").toString();
            }
            return decrypt;
        }
        catch (Exception e) {
            log.warn("BasicTokenUtils#validateToken\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return e.getMessage();
        }
    }

    public ResponseData<ApiBasicTokenDTO> getMerchantIdByDecryptedToken(String decryptedToken) {
        ResponseData<ApiBasicTokenDTO> responseData = new ResponseData<ApiBasicTokenDTO>();
        responseData.setCode(-1);
        responseData.setMessage("fail");
        responseData.setData(null);
        if (!StringUtils.isEmpty((Object)decryptedToken)) {
            String merchantId = decryptedToken.split(",")[0];
            String secret = decryptedToken.split(",")[1];
            if (!StringUtils.isEmpty((Object)merchantId) && !StringUtils.isEmpty((Object)secret)) {
                ApiBasicTokenDTO basicTokenDTO = new ApiBasicTokenDTO();
                basicTokenDTO.setMerchantId(Integer.parseInt(merchantId));
                basicTokenDTO.setAuthenticationKey(secret);
                responseData.setData(basicTokenDTO);
                responseData.setCode(0);
            }
            return responseData;
        }
        return responseData;
    }

    public ResponseData<Boolean> validateSecret(ApiBasicTokenDTO apiBasicToken) {
        ResponseData<Boolean> responseData = new ResponseData<Boolean>();
        responseData.setCode(-1);
        responseData.setData(Boolean.FALSE);
        try {
            CompanyBrandRelationPO companyBrandRelation = this.companyBrandRelationService.findPoByMerchantId(apiBasicToken.getMerchantId());
            if (companyBrandRelation == null) {
                responseData.setMessage("\u6ca1\u6709\u914d\u7f6e\u76f8\u5e94\u7684\u6743\u9650!");
                return responseData;
            }
            if (!companyBrandRelation.getAuthenticationKey().equals(apiBasicToken.getAuthenticationKey())) {
                responseData.setMessage("key\u7684\u6743\u9650\u6709\u8bef\uff01");
            } else {
                responseData.setData(Boolean.TRUE);
                responseData.setCode(0);
                responseData.setMessage(JSON.toJSONString((Object)apiBasicToken));
            }
            return responseData;
        }
        catch (Exception e) {
            log.warn("BasicTokenUtils#validateSecret\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public ResponseData<Boolean> decryptToken(String appKey, String token) {
        ResponseData<Boolean> responseData = new ResponseData<Boolean>();
        responseData.setData(Boolean.FALSE);
        responseData.setMessage("\u65e0\u6548token");
        responseData.setCode(ApiConstants.ERROR_CODE);
        try {
            if (StringUtils.isEmpty((Object)token)) {
                return responseData;
            }
            String validateToken = this.validateToken(appKey, token);
            if (!validateToken.contains(",")) {
                responseData.setMessage(validateToken);
                return responseData;
            }
            ResponseData<ApiBasicTokenDTO> basicToken = this.getMerchantIdByDecryptedToken(validateToken);
            if (SysResponseEnum.SUCCESS.getCode() != basicToken.getCode()) {
                return responseData;
            }
            responseData.setCode(0);
            responseData.setData(Boolean.TRUE);
            responseData.setMessage(JSON.toJSONString((Object)basicToken.getData()));
            return responseData;
        }
        catch (Exception e) {
            log.warn("TokenUtils361#decryptToken\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    public ResponseData<Boolean> decryptTokenJ(String appKey, String token) {
        ResponseData<Boolean> responseData = new ResponseData<Boolean>();
        responseData.setData(Boolean.FALSE);
        responseData.setMessage("\u65e0\u6548token");
        responseData.setCode(ApiConstants.ERROR_CODE);
        try {
            if (StringUtils.isEmpty((Object)token)) {
                return responseData;
            }
            String validateToken = this.validateToken(appKey, token);
            if (!validateToken.contains(",")) {
                responseData.setMessage(validateToken);
                return responseData;
            }
            ResponseData<ApiBasicTokenDTO> basicToken = this.getMerchantIdByDecryptedToken(validateToken);
            if (SysResponseEnum.SUCCESS.getCode() != basicToken.getCode()) {
                return responseData;
            }
            ResponseData<Boolean> validateSecret = this.validateSecret(basicToken.getData());
            if (validateSecret.getData().booleanValue()) {
                responseData.setCode(0);
                responseData.setData(Boolean.TRUE);
            }
            responseData.setMessage(validateSecret.getMessage());
            return responseData;
        }
        catch (Exception e) {
            log.warn("TokenUtils361#decryptTokenJ\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    public ResponseData<Boolean> decryptTokenFromMenDale(String token) {
        return this.decryptToken("bizvane@Mendale#", token);
    }

    public static void main(String[] args) {
        BasicTokenUtils basicTokenUtils = new BasicTokenUtils();
        String encode = basicTokenUtils.encode("bizvane@Mendale#", "141,1e2e8280-96f9-48ff-9bd2-c63042be10ea");
        System.out.println(encode);
        String s = basicTokenUtils.validateToken("bizvane@Mendale#", encode);
        System.out.println(s);
    }
}

