/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils;

import com.wmeimob.fastboot.bizvane.utils.FileUtil;
import com.wmeimob.fastboot.excel.DataConvert;
import com.wmeimob.fastboot.excel.DataTypeConverter;
import com.wmeimob.fastboot.excel.ExcelExport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelHelper {
    public static <T> Workbook exportFromList(List<T> srcList, String[] headNames, String[] dataFieldNames, Class<T> tClass, HttpServletRequest request) throws IOException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        String osNameSuffix = FileUtil.getOsNameSuffix(request);
        if (".xlsx".equalsIgnoreCase(osNameSuffix)) {
            SXSSFWorkbook result = ExcelHelper.exportFromList(srcList, (Map)null, headNames, dataFieldNames, tClass);
            return result;
        }
        HSSFWorkbook result = com.wmeimob.fastboot.excel.ExcelHelper.exportFromList(srcList, (Map)null, (String[])headNames, (String[])dataFieldNames, tClass);
        return result;
    }

    public static <T> SXSSFWorkbook exportFromList(List<T> srcList, Map<String, DataConvert<T>> convertMap, String[] headNames, String[] dataFieldNames, Class<T> tClass) throws IOException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        return ExcelHelper.exportFromList(srcList, convertMap, headNames, obj -> {
            ArrayList<String> objectFieldValues = new ArrayList<String>();
            for (int i = 0; i < dataFieldNames.length; ++i) {
                Field field = ExcelHelper.getField(tClass, dataFieldNames[i]);
                String val = DataTypeConverter.parseString((Object)field.get(obj));
                if (convertMap != null && convertMap.get(dataFieldNames[i]) != null) {
                    val = ((DataConvert)convertMap.get(dataFieldNames[i])).convert(val, obj);
                }
                objectFieldValues.add(val);
            }
            return objectFieldValues;
        });
    }

    public static <T> SXSSFWorkbook exportFromList(List<T> srcList, Map<String, DataConvert<T>> convertMap, String[] headNames, ExcelExport<T> excelExport) throws NoSuchFieldException, IllegalAccessException {
        Cell cell;
        SXSSFWorkbook wb = new SXSSFWorkbook();
        Sheet sheet = wb.createSheet("sheet1");
        Row row0 = sheet.createRow(0);
        CellStyle cellStyle = wb.createCellStyle();
        Font font = wb.createFont();
        font.setBoldweight((short)700);
        cellStyle.setFont(font);
        cellStyle.setAlignment((short)2);
        for (int i = 0; i < headNames.length; ++i) {
            cell = row0.createCell(i);
            sheet.setColumnWidth(i, 3662);
            cell.setCellValue(headNames[i]);
            cell.setCellStyle(cellStyle);
        }
        CellStyle dataCellStyle = wb.createCellStyle();
        for (int i = 0; i < srcList.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            T obj = srcList.get(i);
            List columns = excelExport.getColumns(obj);
            for (int j = 0; j < columns.size(); ++j) {
                cell = row.createCell(j);
                cell.setCellValue((String)columns.get(j));
                cell.setCellStyle(dataCellStyle);
                sheet.setDefaultColumnStyle(j, cellStyle);
            }
        }
        return wb;
    }

    private static Field getField(Class tClass, String fieldName) {
        Field field = null;
        try {
            field = tClass.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException var7) {
            NoSuchFieldException e = var7;
            Class sClass = tClass.getSuperclass();
            if (sClass != Object.class) {
                return ExcelHelper.getField(sClass, fieldName);
            }
            try {
                throw new NoSuchFieldException(e.getMessage());
            }
            catch (NoSuchFieldException var6) {
                var6.printStackTrace();
            }
        }
        return field;
    }
}

