/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.SendOrderMsgRecordLogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.SendOrderMsgRecordRefundStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.SendOrderMsgRecordStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.SendOrderMsgRecordTypeEnum;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.RefundOrderPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SendOrderMsgRecordPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.RefundOrderPOExample;
import com.wmeimob.fastboot.bizvane.po.SendOrderMsgRecordPO;
import com.wmeimob.fastboot.bizvane.po.SendOrderMsgRecordPOExample;
import com.wmeimob.fastboot.bizvane.po.SendOrderMsgRecordPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.service.SendOrderMsgRecordService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SendOrderMsgRecordServiceImpl
implements SendOrderMsgRecordService {
    private static final Logger log = LoggerFactory.getLogger(SendOrderMsgRecordServiceImpl.class);
    @Resource
    private SendOrderMsgRecordPOMapper sendOrderMsgRecordPOMapper;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Resource
    private RefundOrderPOMapper refundOrderPOMapper;

    @Override
    public Boolean addOrderMsgRecord(Integer merchantId, String orderNo, Orders orders) {
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (CollectionUtils.isEmpty(companyBrandRelationPOS)) {
            log.warn("\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6ecompany_brand_relation\u8868");
            return Boolean.FALSE;
        }
        CompanyBrandRelationPO companyBrandRelationPO = companyBrandRelationPOS.get(0);
        SendOrderMsgRecordPOExample sendOrderMsgRecordPOExample = new SendOrderMsgRecordPOExample();
        sendOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(orderNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendOrderMsgRecordPO> sendOrderMsgRecordPOS = this.sendOrderMsgRecordPOMapper.selectByExample(sendOrderMsgRecordPOExample);
        if (!CollectionUtils.isEmpty(sendOrderMsgRecordPOS)) {
            log.warn("t_send_order_msg_record\u8868\u5df2\u5b58\u5728\u8ba2\u5355:{}", (Object)orderNo);
            return Boolean.FALSE;
        }
        OrdersPOExample ordersPOExample = new OrdersPOExample();
        ordersPOExample.createCriteria().andOrderNoEqualTo(orderNo).andValidEqualTo(true);
        long rows = this.ordersPOMapper.countByExample(ordersPOExample);
        if (rows == 0L) {
            log.warn("orders\u8868\u4e0d\u5b58\u5728\u8ba2\u5355:{}", (Object)orderNo);
            return Boolean.FALSE;
        }
        String traceId = MDC.get((String)"traceId");
        SendOrderMsgRecordPOWithBLOBs sendOrderMsgRecordPO = new SendOrderMsgRecordPOWithBLOBs();
        sendOrderMsgRecordPO.setMerchantId(merchantId);
        sendOrderMsgRecordPO.setSysBrandId(companyBrandRelationPO.getBrandId());
        sendOrderMsgRecordPO.setOrderNo(orderNo);
        sendOrderMsgRecordPO.setJsonContent(JSON.toJSONString((Object)orders));
        sendOrderMsgRecordPO.setTrace(traceId);
        sendOrderMsgRecordPO.setType(SendOrderMsgRecordTypeEnum.ORDER.getCode());
        sendOrderMsgRecordPO.setStatus(SendOrderMsgRecordStatusEnum.CREATE.getCode());
        sendOrderMsgRecordPO.setGmtCreate(new Date());
        this.sendOrderMsgRecordPOMapper.insertSelective(sendOrderMsgRecordPO);
        log.info("\u5546\u57ce\u53d1\u9001\u8bb0\u5f55id:{}", (Object)sendOrderMsgRecordPO.getSendOrderMsgRecordId());
        return Boolean.TRUE;
    }

    @Override
    public Boolean addRefundOrderMsgRecord(Integer merchantId, String refundNo, RefundOrder refundOrder) {
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (CollectionUtils.isEmpty(companyBrandRelationPOS)) {
            log.warn("\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6ecompany_brand_relation\u8868");
            return Boolean.FALSE;
        }
        CompanyBrandRelationPO companyBrandRelationPO = companyBrandRelationPOS.get(0);
        SendOrderMsgRecordPOExample sendOrderMsgRecordPOExample = new SendOrderMsgRecordPOExample();
        sendOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(refundNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.REFUND_ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendOrderMsgRecordPO> sendOrderMsgRecordPOS = this.sendOrderMsgRecordPOMapper.selectByExample(sendOrderMsgRecordPOExample);
        if (!CollectionUtils.isEmpty(sendOrderMsgRecordPOS)) {
            log.warn("t_send_order_msg_record\u8868\u5df2\u5b58\u5728\u9000\u5355:{}", (Object)refundNo);
            return Boolean.FALSE;
        }
        RefundOrderPOExample refundOrderPOExample = new RefundOrderPOExample();
        refundOrderPOExample.createCriteria().andRefundNoEqualTo(refundNo).andValidEqualTo(1);
        long rows = this.refundOrderPOMapper.countByExample(refundOrderPOExample);
        if (rows == 0L) {
            log.warn("refund_order\u8868\u4e0d\u5b58\u5728\u9000\u5355:{}", (Object)refundNo);
            return Boolean.FALSE;
        }
        String traceId = MDC.get((String)"traceId");
        SendOrderMsgRecordPOWithBLOBs sendOrderMsgRecordPO = new SendOrderMsgRecordPOWithBLOBs();
        sendOrderMsgRecordPO.setMerchantId(merchantId);
        sendOrderMsgRecordPO.setSysBrandId(companyBrandRelationPO.getBrandId());
        sendOrderMsgRecordPO.setOrderNo(refundNo);
        sendOrderMsgRecordPO.setJsonContent(JSON.toJSONString((Object)refundOrder));
        sendOrderMsgRecordPO.setTrace(traceId);
        sendOrderMsgRecordPO.setType(SendOrderMsgRecordTypeEnum.REFUND_ORDER.getCode());
        sendOrderMsgRecordPO.setStatus(SendOrderMsgRecordStatusEnum.CREATE.getCode());
        sendOrderMsgRecordPO.setGmtCreate(new Date());
        this.sendOrderMsgRecordPOMapper.insertSelective(sendOrderMsgRecordPO);
        log.info("\u5546\u57ce\u53d1\u9001\u8bb0\u5f55id:{}", (Object)sendOrderMsgRecordPO.getSendOrderMsgRecordId());
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateRefundOrderBegin(String refundNo) {
        SendOrderMsgRecordPOExample sendOrderMsgRecordPOExample = new SendOrderMsgRecordPOExample();
        sendOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(refundNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.REFUND_ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendOrderMsgRecordPO> sendOrderMsgRecordPOS = this.sendOrderMsgRecordPOMapper.selectByExample(sendOrderMsgRecordPOExample);
        if (CollectionUtils.isEmpty(sendOrderMsgRecordPOS)) {
            return Boolean.FALSE;
        }
        SendOrderMsgRecordPO sendOrderMsgRecordPO = sendOrderMsgRecordPOS.get(0);
        SendOrderMsgRecordPOWithBLOBs sendOrderMsgRecordPOParam = new SendOrderMsgRecordPOWithBLOBs();
        sendOrderMsgRecordPOParam.setSendOrderMsgRecordId(sendOrderMsgRecordPO.getSendOrderMsgRecordId());
        sendOrderMsgRecordPOParam.setRefundStatus(SendOrderMsgRecordRefundStatusEnum.BEGIN.getCode());
        sendOrderMsgRecordPOParam.setGmtModified(new Date());
        this.sendOrderMsgRecordPOMapper.updateByPrimaryKeySelective(sendOrderMsgRecordPOParam);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateRefundOrderSuccess(String refundNo) {
        SendOrderMsgRecordPOExample sendOrderMsgRecordPOExample = new SendOrderMsgRecordPOExample();
        sendOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(refundNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.REFUND_ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendOrderMsgRecordPO> sendOrderMsgRecordPOS = this.sendOrderMsgRecordPOMapper.selectByExample(sendOrderMsgRecordPOExample);
        if (CollectionUtils.isEmpty(sendOrderMsgRecordPOS)) {
            return Boolean.FALSE;
        }
        SendOrderMsgRecordPO sendOrderMsgRecordPO = sendOrderMsgRecordPOS.get(0);
        SendOrderMsgRecordPOWithBLOBs sendOrderMsgRecordPOParam = new SendOrderMsgRecordPOWithBLOBs();
        sendOrderMsgRecordPOParam.setSendOrderMsgRecordId(sendOrderMsgRecordPO.getSendOrderMsgRecordId());
        sendOrderMsgRecordPOParam.setRefundStatus(SendOrderMsgRecordRefundStatusEnum.SUCCESS.getCode());
        sendOrderMsgRecordPOParam.setGmtModified(new Date());
        this.sendOrderMsgRecordPOMapper.updateByPrimaryKeySelective(sendOrderMsgRecordPOParam);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateOrderLogistics(String orderNo) {
        SendOrderMsgRecordPOExample sendOrderMsgRecordPOExample = new SendOrderMsgRecordPOExample();
        sendOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(orderNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendOrderMsgRecordPO> sendOrderMsgRecordPOS = this.sendOrderMsgRecordPOMapper.selectByExample(sendOrderMsgRecordPOExample);
        if (CollectionUtils.isEmpty(sendOrderMsgRecordPOS)) {
            return Boolean.FALSE;
        }
        SendOrderMsgRecordPO sendOrderMsgRecordPO = sendOrderMsgRecordPOS.get(0);
        SendOrderMsgRecordPOWithBLOBs sendOrderMsgRecordPOParam = new SendOrderMsgRecordPOWithBLOBs();
        sendOrderMsgRecordPOParam.setSendOrderMsgRecordId(sendOrderMsgRecordPO.getSendOrderMsgRecordId());
        sendOrderMsgRecordPOParam.setLogisticsStatus(SendOrderMsgRecordLogisticsStatusEnum.SUCCESS.getCode());
        sendOrderMsgRecordPOParam.setGmtModified(new Date());
        this.sendOrderMsgRecordPOMapper.updateByPrimaryKeySelective(sendOrderMsgRecordPOParam);
        return Boolean.TRUE;
    }
}

