/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.BrandRelationNew;
import com.wmeimob.fastboot.bizvane.entity.BrandRelationNewExample;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.mapper.BrandRelationNewByDesignerMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyBrandRelationServiceImpl
implements CompanyBrandRelationService {
    private static final Logger log = LoggerFactory.getLogger(CompanyBrandRelationServiceImpl.class);
    @Resource
    private BrandRelationNewByDesignerMapper brandRelationNewByDesignerMapper;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;

    @Override
    public Integer getBrandIdByMerchantId(Integer merchantId) {
        log.info("SysBrandIdUtil getSysBrandId merichantId:{}", (Object)merchantId);
        BrandRelationNewExample example = new BrandRelationNewExample();
        example.createCriteria().andMerchantIdEqualTo(merchantId);
        List<BrandRelationNew> brandRelationNews = this.brandRelationNewByDesignerMapper.selectByExample(example);
        log.info("brandRelationNews :{}", brandRelationNews);
        if (brandRelationNews.size() > 1) {
            log.info("\u8be5\u5546\u6237\u5b58\u5728\u591a\u4e2abrandId");
            return null;
        }
        return brandRelationNews.get(0).getBrandId();
    }

    @Override
    public Integer getMainMallMerchantIdByMerchantId(Integer merchantId) {
        log.info("SysBrandIdUtil getMainMallMerchantIdByMerchatId merichantId:{}", (Object)merchantId);
        Integer mainMallMerchantId = this.brandRelationNewByDesignerMapper.selectMainMallMerchantIdByMerchantId(merchantId);
        if (mainMallMerchantId == null) {
            log.info("SysBrandIdUtil#getMainMallMerchantIdByMerchatId#mainMallMerchantId\u4e0d\u5b58\u5728");
            throw new MallCommonException("\u8be5\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        log.info("CompanyBrandRelationServiceImpl#getMainMallMerchantIdByMerchantId#50#mainMallMerchantId:{}", (Object)mainMallMerchantId);
        return mainMallMerchantId;
    }

    @Override
    public CompanyBrandRelationPO getPOByMerchantId(Integer merchantId) {
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (!CollectionUtils.isEmpty(companyBrandRelationPOS)) {
            return companyBrandRelationPOS.get(0);
        }
        return null;
    }

    @Override
    public List<CompanyBrandRelationPO> allKidMallByMerchangId(Integer merchantId) {
        log.info("CompanyBrandRelationServiceImpl#getAllKidMallByMerchangId#75#merchantId:{}", (Object)merchantId);
        Integer mainMallMerchantId = this.getMainMallMerchantIdByMerchantId(merchantId);
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andBrandIdEqualTo(mainMallMerchantId);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        log.info("CompanyBrandRelationServiceImpl#getAllKidMallByMerchangId#85#companyBrandRelationPOS:{}", (Object)JSON.toJSONString(companyBrandRelationPOS));
        return companyBrandRelationPOS;
    }

    @Override
    public CompanyBrandRelationPO findPoByMerchantId(Integer merchantId) {
        log.info("CompanyBrandRelationServiceImpl#findPoByMerchantId:{}", (Object)JSON.toJSONString((Object)merchantId));
        try {
            CompanyBrandRelationPOExample companyBrandRelationExample = new CompanyBrandRelationPOExample();
            companyBrandRelationExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
            List<CompanyBrandRelationPO> companyBrandRelationList = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationExample);
            log.info("companyBrandRelationList==>:{}", (Object)JSON.toJSONString(companyBrandRelationList));
            if (CollectionUtils.isEmpty(companyBrandRelationList)) {
                return null;
            }
            return companyBrandRelationList.get(0);
        }
        catch (Exception e) {
            log.warn("CompanyBrandRelationServiceImpl#findPoByMerchantId\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

