/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.sfcrmfacade.interfaces.OrderServiceFeign;
import com.bizvane.sfcrmfacade.models.vo.OrderInfoLogisticsInfoVo;
import com.bizvane.sfcrmfacade.models.vo.OrderInfoRemarkVo;
import com.bizvane.sfcrmfacade.models.vo.OrderInfoStatusVo;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.OrderGift;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.OrdersCommission;
import com.wmeimob.fastboot.bizvane.entity.OrdersFullGift;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.order.OrderPayTypeEnum;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersCommissionMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersFullGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationCategoryPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderOfflineRefPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderPreSalePOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersRepushRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.RefundOrderPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationCategoryPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationDetailPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPOExample;
import com.wmeimob.fastboot.bizvane.po.OrderOfflineRefPOExample;
import com.wmeimob.fastboot.bizvane.po.OrderOfflineRefPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.po.OrderPreSalePO;
import com.wmeimob.fastboot.bizvane.po.OrderPreSalePOExample;
import com.wmeimob.fastboot.bizvane.po.OrderPresellExpandPO;
import com.wmeimob.fastboot.bizvane.po.OrdersRepushRecordPO;
import com.wmeimob.fastboot.bizvane.po.RefundOrderPO;
import com.wmeimob.fastboot.bizvane.po.RefundOrderPOExample;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.OrderPresellExpandService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="commonOrdersServiceImpl")
public class CommonOrdersServiceImpl
implements OrdersService {
    private static final Logger log = LoggerFactory.getLogger(CommonOrdersServiceImpl.class);
    @Resource
    private CustomizationCategoryPOMapper customizationCategoryPOMapper;
    @Resource
    private CustomizationDetailPOMapper customizationDetailPOMapper;
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private OrderOfflineRefPOMapper orderOfflineRefPOMapper;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Resource
    private UserCommissionAccountsMapper userCommissionAccountsMapper;
    @Autowired
    private OrderPreSalePOMapper orderPreSalePOMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private OrderGiftMapper orderGiftMapper;
    @Resource
    private OrdersFullGiftMapper ordersFullGiftMapper;
    @Autowired
    private OrdersCommissionMapper ordersCommissionMapper;
    @Autowired
    private RefundOrderPOMapper refundOrderPOMapper;
    private static final ScheduledThreadPoolExecutor SCHEDULED4COMMISSION = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("wechat-loreal-commission-pool-%d").build());
    @Resource
    private MarketActivityOrdersPOMapper marketActivityOrdersPOMapper;
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;
    @Lazy
    @Autowired
    private OrderServiceFeign orderServiceFeign;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Value(value="${order.push-companyids}")
    private String pushCompanyIds;
    @Resource
    private OrdersRepushRecordPOMapper ordersRepushRecordPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Autowired
    private OrderPresellExpandService orderPresellExpandService;

    public Orders findById(Integer id) {
        log.info("CommonOrdersServiceImpl#findById:{}", (Object)id);
        Orders param = new Orders();
        param.setId(id);
        Orders orders = this.ordersMapper.selectOrdersDetailById(param);
        Assert.notNull((Object)orders, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        String ordersActivityType = orders.getOrdersActivityType();
        if (OrdersStatusEnum.TRADE.equals((Object)orders.getOrderStatus()) && PayStatusEnum.UN_PAY.equals((Object)orders.getPayStatus())) {
            Config config = new Config();
            config.setMerchantId(orders.getMerchantId());
            Config queryConfig = (Config)this.configService.findOneByCondition(config);
            Integer settingCloseMini = queryConfig.getAwaitOrderPayMinute();
            if ("4".equals(ordersActivityType)) {
                Integer marketActivityOrdersId = orders.getMarketActivityOrdersId();
                MarketActivityOrdersPO marketActivityOrdersPO = this.marketActivityOrdersPOMapper.selectByPrimaryKey(marketActivityOrdersId);
                MarketActivityPOExample marketActivityPOExample = new MarketActivityPOExample();
                marketActivityPOExample.createCriteria().andActivityNoEqualTo(marketActivityOrdersPO.getActivityNo()).andActivityTypeEqualTo("2").andValidEqualTo(Boolean.TRUE);
                List<MarketActivityPO> marketActivityPOList = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
                if (!CollectionUtils.isEmpty(marketActivityPOList)) {
                    settingCloseMini = marketActivityPOList.get(0).getMarketActivityAwaitOrderClose();
                }
            }
            Date date = new Date();
            long result = orders.getGmtCreate().getTime() + (long)(settingCloseMini * 60) * 1000L;
            date.setTime(0L);
            Date now = new Date();
            if (now.getTime() - result <= 0L) {
                date.setTime(now.getTime() - result);
            }
            orders.setPayDeadLine(date);
        }
        orders.getItems().forEach(orderItems -> {
            log.info("\u67e5\u8be2\u5230\u7684\u8ba2\u5355\u660e\u7ec6\u4e3a:{}", JSON.toJSON((Object)orderItems));
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey(orderItems.getGoodsId());
            OrderPreSalePOExample orderPreSalePOExample = new OrderPreSalePOExample();
            orderPreSalePOExample.createCriteria().andOrderIdEqualTo(orderItems.getOrderId()).andMerchantIdEqualTo(goods.getMerchantId()).andValidEqualTo(true).andGoodsIdEqualTo(goods.getId());
            List<OrderPreSalePO> preSaleOrderPOS = this.orderPreSalePOMapper.selectByExample(orderPreSalePOExample);
            if (!CollectionUtils.isEmpty(preSaleOrderPOS)) {
                orders.setPreSaleTime(preSaleOrderPOS.get(0).getPreSaleTime());
                orders.setPreSendDay(preSaleOrderPOS.get(0).getPreSendDay());
            }
            orderItems.setGoodsNo(goods != null ? goods.getGoodsNo() : null);
            Example example = new Example(OrderGift.class);
            example.createCriteria().andEqualTo("orderId", (Object)orderItems.getOrderId()).andEqualTo("orderItemId", (Object)orderItems.getId()).andEqualTo("skuNo", (Object)orderItems.getGoodsSkuNo());
            List gifts = this.orderGiftMapper.selectByExample(example);
            orderItems.setGifts(gifts);
            if (orderItems.getCustomizationDetailId() != null) {
                CustomizationDetailPO customizationDetailPO = this.customizationDetailPOMapper.selectByPrimaryKey(orderItems.getCustomizationDetailId());
                orderItems.setCustomizationDetailImgPath(customizationDetailPO.getCustomizationDetailImgPath());
                CustomizationCategoryPO customizationCategoryPO = this.customizationCategoryPOMapper.selectByPrimaryKey(customizationDetailPO.getCustomizationCategoryId());
                orderItems.setCustomizationCategoryName(customizationCategoryPO.getCustomizationCategoryName());
            }
            orders.setGifts(gifts);
        });
        Example example = new Example(OrdersFullGift.class);
        example.createCriteria().andEqualTo("orderId", (Object)id);
        List fullGifts = this.ordersFullGiftMapper.selectByExample(example);
        if (fullGifts.size() > 0) {
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            fullGifts.forEach(ordersFullGift -> {
                Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey(ordersFullGift.getGoodId());
                goods.setCount(ordersFullGift.getGoodNum());
                goodsList.add(goods);
            });
            orders.setFullGifts(goodsList);
        }
        if (OrderActivityTypeEnum.YS.getCode().toString().equals(ordersActivityType)) {
            Integer presellStatus = orders.getPresellStatus();
            if (!OrderPreSellStatusEnum.NONE.getCode().equals(presellStatus)) {
                List<OrderPresellExpandPO> orderPresellExpandPOS = this.orderPresellExpandService.queryByOrderNo(orders.getOrderNo());
                orders.setOrderPresellExpandPOList(orderPresellExpandPOS);
            }
            GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(orders.getItems().get(0).getGoodsId());
            orders.setPreSellGood(goodsPO);
        }
        if (OrderPayTypeEnum.OFF_LINE.getCode().equals(orders.getPayType())) {
            OrderOfflineRefPOExample selectOfflineInfo = new OrderOfflineRefPOExample();
            selectOfflineInfo.createCriteria().andOrderNoEqualTo(orders.getOrderNo());
            List<OrderOfflineRefPOWithBLOBs> orderOfflineRefPOS = this.orderOfflineRefPOMapper.selectByExampleWithBLOBs(selectOfflineInfo);
            if (!CollectionUtils.isEmpty(orderOfflineRefPOS)) {
                OrderOfflineRefPOWithBLOBs offlineRefPO = orderOfflineRefPOS.get(0);
                orders.setOfflineOrderComment(offlineRefPO.getOfflineOrderComment());
                orders.setOfflineAuditorName(offlineRefPO.getOfflineAuditorName());
                orders.setOfflineSerialNumber(offlineRefPO.getOfflineSerialNumber());
                orders.setOfflineOrderCommentSecond(offlineRefPO.getOfflineOrderCommentSecond());
                orders.setOfflineAuditorNameSecond(offlineRefPO.getOfflineAuditorNameSecond());
                orders.setOfflineSerialNumberSecond(offlineRefPO.getOfflineSerialNumberSecond());
            }
        }
        log.info("order:{}", (Object)JSON.toJSONString((Object)orders));
        return orders;
    }

    @Override
    public void confirm(Orders orders1) {
        log.info("\u786e\u8ba4\u6536\u8d27\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)orders1));
        if (orders1.getUserId() == null) {
            throw new UserException();
        }
        Assert.notNull((Object)orders1.getId(), (String)"\u8ba2\u5355ID");
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("userId", (Object)orders1.getUserId()).andEqualTo("id", (Object)orders1.getId());
        Orders orders = this.ordersMapper.selectByIdAndUserId(orders1.getUserId(), orders1.getId());
        if (orders == null) {
            throw new CustomException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!PayStatusEnum.SUCCESS.equals((Object)orders.getPayStatus())) {
            throw new CustomException("\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        if (!LogisticsStatusEnum.SEND.equals((Object)orders.getLogisticsStatus())) {
            throw new CustomException("\u8ba2\u5355\u672a\u53d1\u8d27\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        RefundOrderPOExample refundOrderPOExample = new RefundOrderPOExample();
        refundOrderPOExample.createCriteria().andValidEqualTo(1).andOrderNoEqualTo(orders.getOrderNo()).andAuditStatusNotEqualTo(new Byte("2"));
        List<RefundOrderPO> refundOrderPOS = this.refundOrderPOMapper.selectByExample(refundOrderPOExample);
        if (!CollectionUtils.isEmpty(refundOrderPOS)) {
            throw new CustomException("\u6b64\u8ba2\u5355\u5df2\u6709\u672a\u5904\u7406\u5b8c\u7684\u552e\u540e\u8ba2\u5355\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        log.info("\u65b0\u8ba2\u5355\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)orders));
        Date date = new Date();
        orders.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
        orders.setOrderStatus(OrdersStatusEnum.SUCCESS);
        orders.setReceiptAt(date);
        orders.setGmtModified(date);
        log.info("\u786e\u8ba4\u6536\u8d27\u4e4b\u524d:{}", (Object)orders.getCommission());
        log.info("\u786e\u8ba4\u6536\u83b7\u662f\u5426\u7ed3\u7b97:{}", (Object)orders.getIsSettleCommission());
        int result = this.ordersMapper.updateByExampleSelective(orders, example);
        if (result == 0) {
            log.error("\u786e\u8ba4\u6536\u8d27\u5931\u8d25 => {}", (Object)JSONObject.toJSONString((Object)orders));
            throw new CustomException("\u786e\u8ba4\u6536\u8d27\u5931\u8d25");
        }
        OrdersCommission ordersCommission = new OrdersCommission();
        ordersCommission.setOrderId(orders.getId().longValue());
        ordersCommission.setVersion(0);
        ordersCommission.setCreateDate(new Date());
        this.ordersCommissionMapper.insert(ordersCommission);
        this.updateOrderStatus(orders);
    }

    public List<Orders> findByCondition(Orders condition) {
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("merchantId", (Object)condition.getMerchantId()).andEqualTo("orderStatus", (Object)condition.getOrderStatus()).andEqualTo("logisticsStatus", (Object)condition.getLogisticsStatus()).andEqualTo("payStatus", (Object)condition.getPayStatus()).andCondition("DATEDIFF(SYSDATE(),receipt_at)>", (Object)condition.getCommissionCalcAfterReceiptDays()).andEqualTo("isSettleCommission", (Object)condition.getIsSettleCommission());
        return this.ordersMapper.selectByExample(example);
    }

    @Override
    public List<Orders> findEnabledCommissions(Integer merchantId) {
        Config config = this.configService.findSysConfig(merchantId);
        if (config == null || !config.getIsDistribution().booleanValue()) {
            return new ArrayList<Orders>();
        }
        Orders condition = new Orders();
        condition.setMerchantId(merchantId);
        condition.setEnabledCommission(true);
        condition.setOrderStatus(OrdersStatusEnum.SUCCESS);
        condition.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
        condition.setPayStatus(PayStatusEnum.SUCCESS);
        condition.setCommissionCalcAfterReceiptDays(config.getAwaitOrderReturn());
        condition.setIsSettleCommission(false);
        return this.findByCondition(condition);
    }

    @Override
    public void updateCommissionState(List<Orders> collect) {
        this.ordersMapper.updateCommissionsState(collect);
    }

    @Override
    public ResponseData updateOrderRemark(Orders vo) {
        ResponseData<Integer> responseData = new ResponseData<Integer>();
        String merchantRemark = vo.getMerchantRemark();
        if (StringUtils.isEmpty((Object)merchantRemark)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("merchantRemark\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        int rows = this.ordersMapper.updateOrderRemark(vo);
        CompanyBrandRelationPO companyBrandRelationPO = this.companyBrandRelationService.getPOByMerchantId(vo.getMerchantId());
        if (companyBrandRelationPO == null || !this.isNeedPushOrder(companyBrandRelationPO.getCompanyId())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u975eorder.push-companyids\u4f01\u4e1a\u8ba2\u5355\u4e0d\u9700\u8981\u63a8\u4e2d\u95f4\u5e93");
            return responseData;
        }
        OrderInfoRemarkVo orderInfoRemarkVo = new OrderInfoRemarkVo();
        orderInfoRemarkVo.setOrderNo(vo.getOrderNo());
        orderInfoRemarkVo.setMerchantRemark(merchantRemark);
        com.bizvane.utils.responseinfo.ResponseData interfaceResponseData = this.orderServiceFeign.updateOrderRemark(orderInfoRemarkVo);
        log.info("orderServiceFeign.updateOrderRemark:{}", (Object)JSON.toJSONString((Object)interfaceResponseData));
        if (interfaceResponseData == null || interfaceResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("merchantRemark\u540c\u6b65\u4e2d\u95f4\u5e93\u5931\u8d25");
            return responseData;
        }
        responseData.setData(rows);
        return responseData;
    }

    @Override
    public ResponseData updateOrderLogisticsInfo(Orders vo) {
        ResponseData<Integer> responseData = new ResponseData<Integer>();
        String shippingNo = vo.getShippingNo();
        if (StringUtils.isEmpty((Object)shippingNo)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("shippingNo\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        int rows = this.ordersMapper.updateOrderLogisticsInfo(vo);
        CompanyBrandRelationPO companyBrandRelationPO = this.companyBrandRelationService.getPOByMerchantId(vo.getMerchantId());
        if (companyBrandRelationPO == null || !this.isNeedPushOrder(companyBrandRelationPO.getCompanyId())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u975eorder.push-companyids\u4f01\u4e1a\u8ba2\u5355\u4e0d\u9700\u8981\u63a8\u4e2d\u95f4\u5e93");
            return responseData;
        }
        OrderInfoLogisticsInfoVo orderInfoLogisticsInfoVo = new OrderInfoLogisticsInfoVo();
        orderInfoLogisticsInfoVo.setOrderNo(vo.getOrderNo());
        orderInfoLogisticsInfoVo.setShippingAt(vo.getShippingAt());
        orderInfoLogisticsInfoVo.setShippingNo(shippingNo);
        orderInfoLogisticsInfoVo.setShippingVendor(vo.getShippingVendorName());
        com.bizvane.utils.responseinfo.ResponseData interfaceResponseData = this.orderServiceFeign.updateOrderLogistics(orderInfoLogisticsInfoVo);
        log.info("orderServiceFeign.updateOrderLogistics:{}", (Object)JSON.toJSONString((Object)interfaceResponseData));
        if (interfaceResponseData == null || interfaceResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("shippingNo\u540c\u6b65\u4e2d\u95f4\u5e93\u5931\u8d25");
            return responseData;
        }
        responseData.setData(rows);
        return responseData;
    }

    @Override
    public ResponseData updateOrderStatus(Orders vo) {
        ResponseData responseData = new ResponseData();
        OrdersStatusEnum orderStatus = vo.getOrderStatus();
        if (orderStatus == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("orderStatus\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        CompanyBrandRelationPO companyBrandRelationPO = this.companyBrandRelationService.getPOByMerchantId(vo.getMerchantId());
        if (companyBrandRelationPO == null || !this.isNeedPushOrder(companyBrandRelationPO.getCompanyId())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u975eorder.push-companyids\u4f01\u4e1a\u8ba2\u5355\u4e0d\u9700\u8981\u63a8\u4e2d\u95f4\u5e93");
            return responseData;
        }
        Orders orders = this.ordersMapper.selectByIdAndUserId(vo.getUserId(), vo.getId());
        try {
            OrderInfoStatusVo orderInfoStatusVo = new OrderInfoStatusVo();
            orderInfoStatusVo.setOrderNo(orders.getOrderNo());
            orderInfoStatusVo.setOrderStatus(this.findOrderStatus(orders));
            com.bizvane.utils.responseinfo.ResponseData interfaceResponseData = this.orderServiceFeign.updateOrderStatus(orderInfoStatusVo);
            if (interfaceResponseData == null || interfaceResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("OrderStatus\u540c\u6b65\u4e2d\u95f4\u5e93\u5931\u8d25");
                return responseData;
            }
        }
        catch (Exception e) {
            OrdersRepushRecordPO recordPO = new OrdersRepushRecordPO();
            recordPO.setOrderType(3);
            recordPO.setCreatedate(new Date());
            recordPO.setOrderNo(orders.getOrderNo());
            recordPO.setSysCompanyId(companyBrandRelationPO.getCompanyId());
            recordPO.setAccountCode(orders.getUserNo());
            this.ordersRepushRecordPOMapper.insert(recordPO);
            log.info("\u540c\u6b65\u8ba2\u5355\u72b6\u6001\u5230\u540d\u521b\u4e2d\u95f4\u5e93\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return responseData;
    }

    private String findOrderStatus(Orders o) {
        String status = "";
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.FAIL)) {
            status = "\u5df2\u5173\u95ed";
        }
        if (o.getPayStatus().equals((Object)PayStatusEnum.UN_PAY) && o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE)) {
            status = "\u5f85\u652f\u4ed8";
        }
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.UN_SEND)) {
            status = "\u5f85\u53d1\u8d27";
        }
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.SEND)) {
            status = "\u5df2\u53d1\u8d27";
        }
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.SUCCESS) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.RECEIVED)) {
            status = "\u5df2\u6536\u8d27";
        }
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.SUCCESS)) {
            status = "\u4ea4\u6613\u6210\u529f" + (o.getIsComment() == false ? "(\u5f85\u8bc4\u4ef7)" : "");
        }
        if (OrderActivityTypeEnum.YS.getCode().toString().equals(o.getOrdersActivityType())) {
            if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && OrderPreSellStatusEnum.PART_DEFAULT.getCode().equals(o.getPresellStatus())) {
                status = "\u5f85\u4ed8\u5b9a\u91d1";
            }
            if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && OrderPreSellStatusEnum.PART_PAY_PORTION.getCode().equals(o.getPresellStatus())) {
                status = "\u5f85\u4ed8\u5c3e\u6b3e";
            }
        }
        return status;
    }

    private boolean isNeedPushOrder(Integer companyId) {
        String[] companyIdList;
        boolean isNeedPush = false;
        if (this.pushCompanyIds != null && companyId != null && (companyIdList = org.apache.commons.lang3.StringUtils.split((String)this.pushCompanyIds, (String)",")) != null && companyIdList.length > 0) {
            for (String id : companyIdList) {
                if (!id.equals(companyId.toString())) continue;
                isNeedPush = true;
                break;
            }
        }
        return isNeedPush;
    }
}

