/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.MallLogs;
import com.wmeimob.fastboot.bizvane.entity.OrderPayTypeVO;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.GoodSpecEnum;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.event.RefundEvent;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.utils.StringUtil;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RefundGoodsEventListener
implements ApplicationListener<RefundEvent> {
    private static final Logger log = LoggerFactory.getLogger(RefundGoodsEventListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private GoodsSpecMapper goodsSpecMapper;
    @Autowired
    private OrdersMapper ordersMapper;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;

    public void onApplicationEvent(RefundEvent refundEvent) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            try {
                log.info("RefundGoodsEventListener#onApplicationEvent orderEvent:{}", (Object)JSON.toJSONString((Object)((Object)refundEvent)));
                RefundOrder refundOrder = refundEvent.getRefundOrder();
                Integer pushFlag = refundEvent.getPushFlag();
                if (pushFlag != null && pushFlag.equals(PushFlagEnum.REFUND_GOODS.getPushFlag()) && refundOrder != null && refundOrder.getRefundType().equals(2)) {
                    log.info("RefundGoodsEventListener#onApplicationEvent#\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)refundOrder));
                    Orders puOrders = new Orders();
                    puOrders.setOrderNo(refundOrder.getOrderNo());
                    puOrders = (Orders)this.ordersMapper.selectOne(puOrders);
                    log.info("RefundGoodsEventListener#onApplicationEvent#orders:{}", (Object)JSON.toJSONString((Object)puOrders));
                    CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
                    companyBrandRelation.setMerchantId(puOrders.getMerchantId());
                    companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(companyBrandRelation);
                    puOrders.setSysCompanyId(companyBrandRelation.getCompanyId());
                    Object s = null;
                    MallLogs mallLogs = new MallLogs();
                    puOrders.getItems().forEach(e -> {
                        String[] split;
                        String specIds = e.getSpecIds();
                        String colorCode = null;
                        String sizeCode = null;
                        if (!StringUtils.isEmpty((Object)specIds) && (split = specIds.split(",")).length > 0) {
                            for (int i = 0; i < split.length; ++i) {
                                String id = split[0];
                                GoodsSpec goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey(id);
                                Integer pid = goodsSpec.getPid();
                                if (pid == 0) continue;
                                GoodsSpec parent = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey(pid);
                                String specName = parent.getSpecName();
                                if (GoodSpecEnum.COLOR.getName().equals(specName)) {
                                    colorCode = goodsSpec.getSpecCode();
                                }
                                if (!GoodSpecEnum.SIZE.getName().equals(specName)) continue;
                                sizeCode = goodsSpec.getSpecCode();
                            }
                        }
                        String specCodes = StringUtil.append(colorCode, sizeCode);
                        e.setSpecCode(specCodes);
                    });
                    ArrayList<OrderPayTypeVO> orderPayTypeVOS = new ArrayList<OrderPayTypeVO>();
                    OrderPayTypeVO build = OrderPayTypeVO.builder().payType(puOrders.getPayType()).payMoney(puOrders.getPayAmount()).build();
                    orderPayTypeVOS.add(build);
                    puOrders.setPayTypes(orderPayTypeVOS);
                    log.info("RefundGoodsEventListener#onApplicationEvent#\u5904\u7406\u5b8c\u6210\u8ba2\u5355\u6570\u636e:[{}]", JSON.toJSON((Object)puOrders));
                    this.bizvaneInterface.notifyPaidOrderInfoOffLine(puOrders);
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        });
        this.scheduledThreadPoolExecutor.execute(() -> {
            try {
                RefundOrder refundOrder = refundEvent.getRefundOrder();
                Integer pushFlag = refundEvent.getPushFlag();
                if (pushFlag != null && pushFlag.equals(PushFlagEnum.REFUND_GOODS.getPushFlag()) && refundOrder != null && refundOrder.getRefundType().equals(2)) {
                    log.info("RefundGoodsEventListener#onApplicationEvent#\u9000\u8d27\u9000\u6b3e\u63a8\u9001\u4f01\u5fae\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)refundOrder));
                    this.bizvaneInterface.notifyRefundQW(refundEvent.getRefundOrder());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

