/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.baison.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.baison.dto.requestVO.ParkSonConfig;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonResponseDTO;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BaiSonHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(BaiSonHttpUtil.class);
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyyMMddHHmmss";
    private static final String FORMAT = "json";

    public static void main(String[] args) {
        ParkSonConfig parkSonConfig = new ParkSonConfig();
        parkSonConfig.setKey("SF");
        parkSonConfig.setSecret("36c4cec4fbe182fd799a1b9fb287461b");
        parkSonConfig.setVersion("0.1");
        parkSonConfig.setAccessToken("http://113.247.222.8:9080/e3_oms/webopm/web/?app_act=api/ec&app_mode=func");
        parkSonConfig.setMethodName("order.add");
        new BaiSonHttpUtil().post(parkSonConfig, "{\"lylx\":\"0\",\"receiver_addr\":\"\\u6C5F\\u9634\\u5E02\\u9633\\u5149\\u4E8C\\u624B\\u8F66\\u5E02\\u573A9\\u5E6221\\u53F7\",\"deal_code\":\"JFSC202105161007361391720\",\"sd_code\":\"jfsc\",\"user_name\":\"\\u90C1\\u94ED\",\"receiver_name\":\"\\u90C1\\u94ED\",\"receiver_country\":\"\\u4E2D\\u56FD\",\"receiver_province\":\"\\u6C5F\\u82CF\\u7701\",\"receiver_city\":\"\\u65E0\\u9521\\u5E02\",\"receiver_district\":\"\\u6C5F\\u9634\\u5E02\",\"receiver_address\":\"\\u6C5F\\u9634\\u5E02\\u9633\\u5149\\u4E8C\\u624B\\u8F66\\u5E02\\u573A9\\u5E6221\\u53F7\",\"receiver_mobile\":\"13815126662\",\"order_status\":1,\"add_time\":1621130856,\"pay_time\":1621130856,\"pay_status\":2,\"shipping_fee\":0.0,\"order_amount\":0.0,\"payment\":0.0,\"is_cod\":0,\"source\":\"API\",\"pay_code\":\"weixin\",\"items\":[{\"deal_code\":\"JFSC202105161007361391720\",\"sku\":\"102016339800\",\"goods_sn\":\"102016339800\",\"goods_name\":\"\\u957F\\u7ED2\\u68C9\\u7F0E\\u7EB9\\u5370\\u82B1\\u5927\\u88AB\\u5355\\u56DB\\u4EF6\\u5957\\uFF1A\\u5BD0MINE \\u4F2F\\u660E\\u7FF0\\uFF08\\u5BD0\\uFF09\",\"shop_price\":0.0,\"goods_price\":0.0,\"goods_number\":1,\"is_gift\":1}]}");
    }

    public BaisonResponseDTO post(ParkSonConfig parkSonConfig, String data) {
        log.info("parkSonConfig:{}", (Object)JSON.toJSONString((Object)parkSonConfig));
        String key = parkSonConfig.getKey();
        String secret = parkSonConfig.getSecret();
        String version = parkSonConfig.getVersion();
        String accessToken = parkSonConfig.getAccessToken();
        String methodName = parkSonConfig.getMethodName();
        return this.getBaiSonE3Response(key, secret, version, accessToken, methodName, data);
    }

    public BaisonResponseDTO getBaiSonE3Response(String key, String secret, String version, String accessToken, String methodName, String data) {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        String datetime = BaiSonHttpUtil.getRequestTime();
        paramMap.put("key", key);
        paramMap.put("requestTime", datetime);
        paramMap.put("secret", secret);
        paramMap.put("version", version);
        paramMap.put("serviceType", methodName);
        paramMap.put("sign", this.getSign(paramMap, data));
        paramMap.put("data", data);
        paramMap.remove("secret");
        paramMap.put("format", FORMAT);
        BaisonResponseDTO result = null;
        try {
            JSONObject jsonObject = this.doGet(accessToken, paramMap, methodName);
            result = (BaisonResponseDTO)JSONObject.parseObject((String)jsonObject.toJSONString(), BaisonResponseDTO.class);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
        log.info("E3\u8bf7\u6c42\uff1amethod\uff1a{}--param:{}", (Object)methodName, (Object)JSON.toJSONString((Object)data));
        return result;
    }

    private String getReqStr(String accessToken, Map<String, Object> param) {
        StringBuilder reqParamStr = new StringBuilder();
        if (param != null) {
            reqParamStr.append(accessToken).append("&");
            param.forEach((k, v) -> reqParamStr.append((String)k).append("=").append(v).append("&"));
        }
        return reqParamStr.deleteCharAt(reqParamStr.length() - 1).toString();
    }

    private JSONObject doGet(String url, Map<String, Object> param, String interfaceName) {
        JSONObject jsonObject = null;
        CloseableHttpClient client = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        String params = null;
        try {
            params = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            log.info("BaiSonHttpUtil#\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param)});
            HttpGet httpGet = new HttpGet(url + "&" + params);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            response.close();
            jsonObject = JSONObject.parseObject((String)string);
            log.info("BaiSonHttpUtil#response#\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param), string});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObject;
    }

    private BaisonResponseDTO Okhttp(String url) throws Exception {
        Response response = null;
        Request request = new Request.Builder().get().tag((Object)this).url(url).build();
        log.info("\u8bf7\u6c42\u5b8c\u6574\u8def\u5f84\uff1a{}", (Object)request);
        try {
            OkHttpClient client = new OkHttpClient();
            response = client.newCall(request).execute();
        }
        catch (SocketTimeoutException client) {
            // empty catch block
        }
        String responseText = response.body().string();
        BaisonResponseDTO baisonResponseDTO = (BaisonResponseDTO)JSONObject.parseObject((String)responseText, BaisonResponseDTO.class);
        return baisonResponseDTO;
    }

    private String getSign(Map<String, Object> authMap, String data) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> m : authMap.entrySet()) {
            sb.append(m.getKey()).append("=").append(m.getValue()).append("&");
        }
        sb.append("data=").append(data);
        log.info("\u52a0\u5bc6\u53c2\u6570\uff1a{}", (Object)sb.toString());
        return this.getMD5(sb.toString());
    }

    private String getMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            log.warn("BaiSonHttpUtil#getMD5\u5f02\u5e38,\u8fd4\u56de\u7684\u52a0\u5bc6\u53c2\u6570\u7a7a:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static String getRequestTime() {
        LocalDateTime time = LocalDateTime.now(ZoneId.systemDefault());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        return dateTimeFormatter.format(time);
    }
}

