/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.baison.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.json.gson.JsonUtil;
import com.wmeimob.fastboot.baison.dto.requestVO.ParkSonConfig;
import com.wmeimob.fastboot.baison.dto.requestVO.ParkSonOrderAddItems;
import com.wmeimob.fastboot.baison.dto.requestVO.ParkSonOrderAddRequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.ParkSonOrderPushRequestVO;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonResponseDTO;
import com.wmeimob.fastboot.baison.service.ParkSonOrderService;
import com.wmeimob.fastboot.baison.utils.BaiSonHttpUtil;
import com.wmeimob.fastboot.bizvane.enums.skyworth.IntegralGoodsPriceTypeEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.newmapper.custommapper.IntegralOrdersPlusPOMapper;
import com.wmeimob.fastboot.bizvane.po.IntegralGoodsPO;
import com.wmeimob.fastboot.bizvane.po.IntegralMerchantOfflineConfigPO;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.QueryIntegralOrderItemsListResponseVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.QueryIntegralOrderWithDetailsRequestVO;
import com.wmeimob.fastboot.bizvane.vo.Integralstore.order.QueryIntegralOrderWithDetailsResponseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ParkSonOrderServiceImpl
implements ParkSonOrderService {
    private static final Logger log = LoggerFactory.getLogger(ParkSonOrderServiceImpl.class);
    @Resource
    private IntegralOrdersPlusPOMapper integralOrdersPlusPoMapper;
    @Autowired
    private BaiSonHttpUtil baiSonHttpUtil;

    @Override
    public BaisonResponseDTO parkSonIntegralOrderPush(ParkSonOrderPushRequestVO parkSonOrderPushRequestVo) {
        log.info("ParkSonOrderServiceImpl#parkSonOrderPush:{}", (Object)JSON.toJSONString((Object)parkSonOrderPushRequestVo));
        BaisonResponseDTO responseDTO = new BaisonResponseDTO();
        try {
            boolean empty = BeanUtil.isEmpty((Object)parkSonOrderPushRequestVo, (String[])new String[]{"config", "orderId"});
            if (empty) {
                throw new MallCommonException("\u8ba2\u5355\u53f7\u6216\u8005\u5546\u6237\u53f7\u7a7a\uff0c\u4e2d\u65ad\u63a8\u9001\uff01");
            }
            QueryIntegralOrderWithDetailsRequestVO detailsRequest = new QueryIntegralOrderWithDetailsRequestVO();
            detailsRequest.setOrderId(parkSonOrderPushRequestVo.getOrderId());
            detailsRequest.setOrderNo(parkSonOrderPushRequestVo.getOrderNo());
            detailsRequest.setMerchantId(parkSonOrderPushRequestVo.getMerchantId());
            List<QueryIntegralOrderWithDetailsResponseVO> orderWithDetailsResponseVOList = this.integralOrdersPlusPoMapper.queryIntegralOrderWithDetailsList(detailsRequest);
            if (CollectionUtils.isEmpty(orderWithDetailsResponseVOList)) {
                throw new MallCommonException("\u6ca1\u6709\u83b7\u53d6\u5230\u8ba2\u5355\u6570\u636e\uff0c\u4e2d\u65ad\u63a8\u9001\uff01" + JSON.toJSONString((Object)detailsRequest));
            }
            QueryIntegralOrderWithDetailsResponseVO orderWithDetails = orderWithDetailsResponseVOList.get(0);
            IntegralMerchantOfflineConfigPO config = parkSonOrderPushRequestVo.getConfig();
            String jsonContent = config.getJsonContent();
            if (StringUtils.isEmpty((Object)jsonContent)) {
                throw new MallCommonException("jsonContent\u7a7a");
            }
            String pushType = config.getPushType();
            if (StringUtils.isEmpty((Object)pushType)) {
                throw new MallCommonException("pushType\u7a7a\uff0c\u4e2d\u65ad\u63a8\u9001\uff01");
            }
            String[] split = pushType.split(",");
            List pushTypeList = Stream.of(split).collect(Collectors.toList());
            boolean contains = pushTypeList.contains(orderWithDetails.getOrderStatus());
            if (!contains) {
                throw new MallCommonException("\u63a8\u9001\u65f6\u72b6\u6001\u72b6\u6001\u6709\u95ee\u9898\uff0c\u4e2d\u65ad\u63a8\u9001\uff01");
            }
            log.info(orderWithDetails.getOrderNo() + "\u63a8\u9001\u65f6\u72b6\u6001:" + orderWithDetails.getOrderStatus());
            if (!"0".equals(orderWithDetails.getOrderType())) {
                throw new MallCommonException(orderWithDetails.getOrderNo() + "\u4e3a\u81ea\u63d0\u8ba2\u5355\uff0c\u4e0d\u63a8\u9001\u767e\u76db");
            }
            ParkSonConfig parkSonConfig = (ParkSonConfig)JSONObject.parseObject((String)jsonContent, ParkSonConfig.class);
            ResponseData<Boolean> params = this.convertParkSonIntegralOrderAddParams(orderWithDetails, parkSonConfig);
            if (!params.getData().booleanValue()) {
                throw new MallCommonException(params.getMessage());
            }
            responseDTO = this.baiSonHttpUtil.post(parkSonConfig, params.getMessage());
            log.info("\u79ef\u5206\u8ba2\u5355\u63a8\u9001\u767e\u76db\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)responseDTO));
        }
        catch (Exception e) {
            log.warn("ParkSonOrderServiceImpl#parkSonOrderPush\u767e\u76db\u8ba2\u5355\u63a8\u9001\u63a5\u53e3\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseDTO.setMessage("\u767e\u76db\u8ba2\u5355\u63a8\u9001\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        return responseDTO;
    }

    private ResponseData<Boolean> convertParkSonIntegralOrderAddParams(QueryIntegralOrderWithDetailsResponseVO orderWithDetails, ParkSonConfig parkSonConfig) {
        ResponseData<Boolean> aBoolean = ResponseUtil.getBoolean(false);
        try {
            ParkSonOrderAddRequestVO addRequestVO = new ParkSonOrderAddRequestVO();
            addRequestVO.setLylx(parkSonConfig.getLylx());
            ArrayList<ParkSonOrderAddItems> orderAddItems = new ArrayList<ParkSonOrderAddItems>();
            Long time = null;
            Date orderTime = orderWithDetails.getOrderTime();
            if (StringUtils.isEmpty((Object)orderTime)) {
                log.info("\u4e0b\u5355\u65f6\u95f4\u65f6\u95f4\u7a7a\u4f7f\u7528\u5f53\u524d\u65f6\u95f4\uff01");
                time = System.currentTimeMillis();
            } else {
                time = orderTime.getTime();
            }
            long secondTimestamps = Math.round((double)time.longValue() * 1.0 / 1000.0);
            addRequestVO.setAdd_time(secondTimestamps);
            addRequestVO.setPay_time(secondTimestamps);
            String orderNo = orderWithDetails.getOrderNo();
            if (StringUtils.isEmpty((Object)orderNo)) {
                return this.failMsg(aBoolean, "\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            }
            addRequestVO.setDeal_code(orderNo);
            addRequestVO.setSd_code(parkSonConfig.getSdCode());
            addRequestVO.setOrder_status(1);
            addRequestVO.setPay_status(2);
            addRequestVO.setPay_code("weixin");
            addRequestVO.setUser_name(StringUtils.isEmpty((Object)orderWithDetails.getMemberName()) ? "" : orderWithDetails.getMemberName());
            addRequestVO.setReceiver_name(this.getReceiverName(orderWithDetails.getShippingName(), orderWithDetails.getMemberName()));
            addRequestVO.setReceiver_province(orderWithDetails.getShippingProvince());
            addRequestVO.setReceiver_city(orderWithDetails.getShippingCity());
            addRequestVO.setReceiver_address(orderWithDetails.getShippingAddress());
            addRequestVO.setReceiver_addr(orderWithDetails.getShippingAddress());
            addRequestVO.setReceiver_district(orderWithDetails.getShippingDistrict());
            addRequestVO.setReceiver_country("\u4e2d\u56fd");
            addRequestVO.setReceiver_mobile(orderWithDetails.getShippingMobile());
            BigDecimal freight = orderWithDetails.getFreight();
            float shippingFee = 0.0f;
            if (!StringUtils.isEmpty((Object)freight)) {
                shippingFee = freight.floatValue();
            }
            addRequestVO.setShipping_fee(Float.valueOf(shippingFee));
            addRequestVO.setSource("API");
            addRequestVO.setIs_cod(0);
            List<QueryIntegralOrderItemsListResponseVO> items = orderWithDetails.getItems();
            if (CollectionUtils.isEmpty(items)) {
                return this.failMsg(aBoolean, "items555\u7a7a");
            }
            BigDecimal salePriceAll = new BigDecimal(0);
            for (QueryIntegralOrderItemsListResponseVO itemVo : items) {
                ParkSonOrderAddItems addItems = new ParkSonOrderAddItems();
                IntegralGoodsPO integralGoodsPo = itemVo.getIntegralGoodsPo();
                addItems.setDeal_code(orderNo);
                String goodsNo = this.getGoodsNo(itemVo);
                String goodsSkuNo = itemVo.getGoodsSkuNo();
                if (StringUtils.isEmpty((Object)goodsSkuNo)) {
                    return this.failMsg(aBoolean, "goodsSkuNo\u7a7a");
                }
                goodsSkuNo = goodsSkuNo + "00";
                addItems.setSku(goodsSkuNo);
                addItems.setGoods_sn(goodsSkuNo);
                String goodsName = integralGoodsPo.getGoodsName();
                if (StringUtils.isEmpty((Object)goodsName)) {
                    return this.failMsg(aBoolean, "goodsName\u7a7a");
                }
                addItems.setGoods_name(goodsName);
                float shopPrice = 0.0f;
                BigDecimal salePrice = integralGoodsPo.getCashPrice();
                if (!StringUtils.isEmpty((Object)salePrice)) {
                    shopPrice = salePrice.floatValue();
                }
                addItems.setShop_price(Float.valueOf(shopPrice));
                addItems.setGoods_price(Float.valueOf(shopPrice));
                addItems.setGoods_number(itemVo.getSaleQuantity());
                String priceType = integralGoodsPo.getPriceType();
                if (IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equals(priceType)) {
                    addItems.setIs_gift(1);
                }
                orderAddItems.add(addItems);
                salePriceAll = salePriceAll.add(itemVo.getSalePrice());
            }
            BigDecimal freightAndSale = salePriceAll.add(freight);
            log.info("\u8fd0\u8d39+\u73b0\u91d1=" + freightAndSale);
            float floatValue = freightAndSale.floatValue();
            addRequestVO.setOrder_amount(Float.valueOf(floatValue));
            addRequestVO.setPayment(Float.valueOf(floatValue));
            addRequestVO.setItems(orderAddItems);
            String jsParams = JsonUtil.toJson((Object)addRequestVO);
            log.info("orderAdd \u8ba2\u5355\u6570\u636e\uff1a{}", (Object)jsParams);
            aBoolean.setData(true);
            aBoolean.setCode(0);
            aBoolean.setMessage(jsParams);
            return aBoolean;
        }
        catch (Exception e) {
            log.warn("ParkSonOrderServiceImpl#convertParkSonIntegralOrderAddParams\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return this.failMsg(aBoolean, e.getMessage());
        }
    }

    private String getGoodsNo(QueryIntegralOrderItemsListResponseVO itemVo) {
        IntegralGoodsPO integralGoodsPo = itemVo.getIntegralGoodsPo();
        if (StringUtils.isEmpty((Object)integralGoodsPo)) {
            throw new MallCommonException("integralGoodsPo\u7a7a");
        }
        return integralGoodsPo.getGoodsNo();
    }

    private String getReceiverName(String shippingName, String memberName) {
        if (StringUtils.isEmpty((Object)shippingName)) {
            return "";
        }
        return shippingName;
    }

    private ResponseData<Boolean> failMsg(ResponseData<Boolean> aBoolean, String msg) {
        aBoolean.setMessage(msg);
        return aBoolean;
    }
}

