/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.enums.activity;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public enum ActivityTypeEnum {
    SPECIAL(1, "\u4e13\u9898\u6d3b\u52a8"),
    SECKILL(2, "\u79d2\u6740\u6d3b\u52a8");

    private Integer code;
    private String message;

    private ActivityTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public static ActivityTypeEnum getByCode(Integer code) {
        ActivityTypeEnum[] values;
        for (ActivityTypeEnum value : values = ActivityTypeEnum.values()) {
            if (value.getCode() != code) continue;
            return value;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static String getFormatRule(int code, String unformattedRule) {
        if (code >= 4 || StringUtils.isBlank((String)unformattedRule)) {
            return null;
        }
        Object[] rules = unformattedRule.split(",");
        if (ArrayUtils.isEmpty((Object[])rules)) {
            return null;
        }
        String result = null;
        switch (code) {
            case 0: {
                result = "\u6bcf\u5929";
                break;
            }
            case 1: {
                List dayOfWeek = Arrays.stream(rules).map(Integer::valueOf).map(ActivityTypeEnum::getWeekDay).collect(Collectors.toList());
                result = String.join((CharSequence)",", dayOfWeek);
                break;
            }
            case 2: {
                List daysOfMonth = Arrays.stream(rules).map(rule -> rule + "\u53f7").collect(Collectors.toList());
                result = String.join((CharSequence)",", daysOfMonth);
                break;
            }
            case 3: {
                result = unformattedRule;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static String getWeekDay(int num) {
        String decribe = null;
        switch (num) {
            case 1: {
                decribe = "\u5468\u4e00";
                break;
            }
            case 2: {
                decribe = "\u5468\u4e8c";
                break;
            }
            case 3: {
                decribe = "\u5468\u4e09";
                break;
            }
            case 4: {
                decribe = "\u5468\u56db";
                break;
            }
            case 5: {
                decribe = "\u5468\u4e94";
                break;
            }
            case 6: {
                decribe = "\u5468\u516d";
                break;
            }
            case 7: {
                decribe = "\u5468\u65e5";
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
        return decribe;
    }
}

