/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.enums;

import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityStatus;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityType;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public enum IntegralActivityStatus {
    HAVE_NOT_START(0, "\u672a\u5f00\u59cb"),
    ON_GOING(1, "\u8fdb\u884c\u4e2d"),
    HAS_ENDED(2, "\u5df2\u7ed3\u675f"),
    HAS_BEEN_STOP(3, "\u5df2\u505c\u7528");

    private Integer code;
    private String message;

    private IntegralActivityStatus(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static String getMessageFromCode(Integer code) {
        IntegralActivityStatus[] values;
        for (IntegralActivityStatus value : values = IntegralActivityStatus.values()) {
            if (value.code != code) continue;
            return value.getMessage();
        }
        return null;
    }

    public static String calculateNextTime(Integer type, String rule, Long seckillBeginTime, Long seckillEndTime) {
        if (type == null || seckillBeginTime == null || seckillEndTime == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        DateTime dateTime = new DateTime();
        long timeOffset = dateTime.getSecondOfDay();
        SeckillActivityType currentType = SeckillActivityType.getByCode(type);
        List<Integer> list = new ArrayList<Integer>();
        if (StringUtils.isNotBlank((CharSequence)rule) && !SeckillActivityType.CUSTOMIZE.getCode().equals(type)) {
            String[] split = rule.split(",");
            list = Arrays.stream(split).map(Integer::parseInt).sorted().collect(Collectors.toList());
        }
        String desc = null;
        switch (currentType) {
            case DAY: {
                desc = IntegralActivityStatus.getDateDecr(seckillBeginTime, timeOffset, 1, true);
                break;
            }
            case WEEK: {
                desc = IntegralActivityStatus.calculateNextTimeOfWeekOrMonth(dateTime.getDayOfWeek(), seckillBeginTime, list, timeOffset, dateTime.dayOfWeek().getMaximumValue());
                break;
            }
            case MONTH: {
                desc = IntegralActivityStatus.calculateNextTimeOfWeekOrMonth(dateTime.getDayOfMonth(), seckillBeginTime, list, timeOffset, dateTime.dayOfMonth().getMaximumValue());
                break;
            }
            case CUSTOMIZE: {
                desc = IntegralActivityStatus.calculateNextTimeOfCustomize(rule, seckillBeginTime, seckillEndTime, dateTime);
                break;
            }
        }
        return desc;
    }

    private static String calculateNextTimeOfCustomize(String rule, Long seckillBeginTime, Long seckillEndTime, DateTime dateTime) {
        Object desc = null;
        String[] date = rule.split("~");
        Date begin = DateUtil.parse(date[0] + " " + DateUtil.parseTime(seckillBeginTime), DateUtil.ymdhms);
        Date end = DateUtil.parse(date[1] + " " + DateUtil.parseTime(seckillEndTime), DateUtil.ymdhms);
        Date currentDate = dateTime.toDate();
        if (currentDate.compareTo(begin) < 0) {
            return date[0];
        }
        if (currentDate.compareTo(end) > 0) {
            return null;
        }
        Date currentEndActivityDate = DateUtil.parseDate(DateUtil.parseTime(seckillEndTime));
        if (currentDate.compareTo(currentEndActivityDate) <= 0) {
            return DateUtil.format(currentDate, DateUtil.ymd);
        }
        return DateUtil.format(dateTime.plusDays(1).toDate(), DateUtil.ymd);
    }

    private static String getDateDecr(Long seckillBeginTime, long timeOffset, Integer interval, boolean isIn) {
        if (isIn && timeOffset <= seckillBeginTime) {
            return DateUtil.format(new Date(), DateUtil.ymd);
        }
        return DateUtil.format(DateUtil.addDay(new Date(), interval), DateUtil.ymd);
    }

    private static String calculateNextTimeOfWeekOrMonth(Integer currentDay, Long seckillBeginTime, List<Integer> list, long timeOffset, int maxDay) {
        Integer maxDayOfRule = list.get(list.size() - 1);
        if (currentDay > maxDayOfRule) {
            return IntegralActivityStatus.getDateDecr(seckillBeginTime, timeOffset, maxDay - currentDay + list.get(0), false);
        }
        for (int i = 0; i < list.size(); ++i) {
            Integer day = list.get(i);
            if (currentDay > day) continue;
            if (currentDay == day && currentDay < maxDayOfRule) {
                return IntegralActivityStatus.getDateDecr(seckillBeginTime, timeOffset, list.get(i + 1) - currentDay, true);
            }
            if (currentDay == day && currentDay == maxDayOfRule) {
                return IntegralActivityStatus.getDateDecr(seckillBeginTime, timeOffset, maxDay - maxDayOfRule + list.get(0), true);
            }
            if (currentDay < maxDayOfRule) {
                return IntegralActivityStatus.getDateDecr(seckillBeginTime, timeOffset, list.get(i) - currentDay, false);
            }
            if (currentDay <= maxDayOfRule) continue;
            return IntegralActivityStatus.getDateDecr(seckillBeginTime, timeOffset, maxDay - currentDay + list.get(0), false);
        }
        return null;
    }

    public static SeckillActivityStatus correctStatus(Integer type, String rule, Long seckillBeginTime, Long seckillEndTime, Integer disabled) {
        if (disabled == 1) {
            return SeckillActivityStatus.HAS_BEEN_STOP;
        }
        SeckillActivityStatus currentStatus = null;
        if (type == null || seckillBeginTime == null || seckillEndTime == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        DateTime dateTime = new DateTime();
        Date currentTime = dateTime.toDate();
        long timeOffset = dateTime.getSecondOfDay();
        boolean inCurrentTime = timeOffset >= seckillBeginTime && timeOffset <= seckillEndTime;
        SeckillActivityType currentType = SeckillActivityType.getByCode(type);
        switch (currentType) {
            case DAY: {
                currentStatus = inCurrentTime ? SeckillActivityStatus.ON_GOING : SeckillActivityStatus.HAVE_NOT_START;
                break;
            }
            case WEEK: {
                String[] week = rule.split(",");
                String dayOfWeek = dateTime.getDayOfWeek() + "";
                List<String> weekList = Arrays.asList(week);
                currentStatus = weekList.contains(dayOfWeek) && inCurrentTime ? SeckillActivityStatus.ON_GOING : SeckillActivityStatus.HAVE_NOT_START;
                break;
            }
            case MONTH: {
                String[] month = rule.split(",");
                String dayOfMonth = dateTime.getDayOfMonth() + "";
                List<String> monthList = Arrays.asList(month);
                currentStatus = monthList.contains(dayOfMonth) && inCurrentTime ? SeckillActivityStatus.ON_GOING : SeckillActivityStatus.HAVE_NOT_START;
                break;
            }
            case CUSTOMIZE: {
                String[] date = rule.split("~");
                Date begin = DateUtil.parse(date[0], DateUtil.ymd);
                Date end = DateUtil.parse(date[1] + " " + DateUtil.parseTime(seckillEndTime), DateUtil.ymdhms);
                if (currentTime.compareTo(end) > 0) {
                    currentStatus = SeckillActivityStatus.HAS_ENDED;
                    break;
                }
                if (currentTime.compareTo(begin) >= 0 && timeOffset >= seckillBeginTime && seckillEndTime >= timeOffset) {
                    currentStatus = SeckillActivityStatus.ON_GOING;
                    break;
                }
                currentStatus = SeckillActivityStatus.HAVE_NOT_START;
                break;
            }
        }
        if (currentStatus == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        return currentStatus;
    }

    public static boolean checkStatus(SeckillActivityStatus activityStatus) {
        return HAS_ENDED.getCode().equals(activityStatus.getCode()) || HAS_BEEN_STOP.getCode().equals(activityStatus.getCode());
    }
}

