/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.OrdersCommission;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.mapper.OrdersCommissionMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountsMapper;
import com.wmeimob.fastboot.bizvane.service.CommissionService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommissionServiceImpl
implements CommissionService {
    private static final Logger log = LoggerFactory.getLogger(CommissionServiceImpl.class);
    @Autowired
    UserCommissionAccountsMapper userCommissionAccountsMapper;
    @Autowired
    OrdersMapper ordersMapper;
    @Autowired
    private ConfigService configService;
    @Autowired
    private OrdersCommissionMapper ordersCommissionMapper;

    @Override
    public void update() {
        List list = this.ordersCommissionMapper.selectAll();
        if (list != null && list.size() > 0) {
            for (OrdersCommission ordersCommission : list) {
                OrdersCommission commission = (OrdersCommission)this.ordersCommissionMapper.selectByPrimaryKey(ordersCommission.getId());
                if (commission.getVersion() != 0) continue;
                CommissionService commissionService = (CommissionService)AopContext.currentProxy();
                commissionService.updateOrdersCommission(commission);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrdersCommission(OrdersCommission commission) {
        commission.setVersion(1);
        this.ordersCommissionMapper.updateByPrimaryKeySelective(commission);
        Orders orders = (Orders)this.ordersMapper.selectByPrimaryKey(commission.getOrderId().intValue());
        Config sysconfig = this.configService.findSysConfig(orders.getMerchantId());
        Integer day = sysconfig.getAwaitOrderReturn() != null ? sysconfig.getAwaitOrderReturn() : 0;
        if (System.currentTimeMillis() - commission.getCreateDate().getTime() >= (long)(day * 86400000)) {
            CommissionService commissionService = (CommissionService)AopContext.currentProxy();
            commissionService.changeCommission(orders);
            this.ordersCommissionMapper.deleteByPrimaryKey(commission.getId());
        } else {
            commission.setVersion(0);
            this.ordersCommissionMapper.updateByPrimaryKeySelective(commission);
        }
    }

    @Override
    public void changeCommission(Orders orders) {
        if (orders.getCommission().compareTo(BigDecimal.ZERO) != 0 && !orders.getIsSettleCommission().booleanValue()) {
            UserCommissionAccounts lowerAccounts = this.userCommissionAccountsMapper.selectUserCommissionAccountsByUserNo(orders.getUserNo());
            log.info("\u4e0b\u7ea7\u8d26\u6237:{}", (Object)JSONObject.toJSONString((Object)lowerAccounts));
            BigDecimal commission = orders.getCommission();
            log.info("\u4f63\u91d1\u6570\u91cf:{}", (Object)commission);
            UserCommissionAccounts superiorAccounts = this.userCommissionAccountsMapper.selectUserCommissionAccountsByPid(lowerAccounts.getPid());
            log.info("\u4e0a\u7ea7\u8d26\u6237\u4e3a:{}", (Object)JSONObject.toJSONString((Object)superiorAccounts));
            String amount1 = superiorAccounts.getAmount().toString();
            superiorAccounts.setAmount(new BigDecimal(amount1).add(commission));
            log.info("\u8bbe\u7f6e\u4f59\u989d:{}", (Object)new BigDecimal(amount1).add(commission));
            String amount2 = superiorAccounts.getHistoryAmount().toString();
            superiorAccounts.setHistoryAmount(new BigDecimal(amount2).add(commission));
            log.info("\u8bbe\u7f6e\u5386\u53f2:{}", (Object)new BigDecimal(amount2).add(commission));
            String amount3 = lowerAccounts.getContributionAmount().toString();
            lowerAccounts.setContributionAmount(new BigDecimal(amount3).add(commission));
            log.info("\u8bbe\u7f6e\u4e0b\u7ea7\u8d21\u732e\u5ea6:{}", (Object)lowerAccounts.getContributionAmount().add(commission));
            this.userCommissionAccountsMapper.updateSupAccountsByid(superiorAccounts);
            log.info("\u66f4\u65b0\u4e0a\u7ea7\u8d26\u6237");
            this.userCommissionAccountsMapper.updateLowAccountsComissionByid(lowerAccounts);
            log.info("\u66f4\u65b0\u4e0b\u7ea7\u8d26\u6237");
            this.ordersMapper.updateCommissionsAspect(orders);
        }
    }
}

