/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.idempotent;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.idempotent.Idempotent;
import com.wmeimob.fastboot.bizvane.idempotent.IdempotentKeyUtil;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Aspect
@ConditionalOnClass(value={RedisTemplate.class})
public class IdempotentAspect {
    private static final Logger log = LoggerFactory.getLogger(IdempotentAspect.class);
    private static final String KEY_TEMPLATE = "idempotent_%s";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Pointcut(value="@annotation(com.wmeimob.fastboot.bizvane.idempotent.Idempotent)")
    public void executeIdempotent() {
    }

    @Around(value="executeIdempotent()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        String key = String.format(KEY_TEMPLATE, idempotent.value() + "_" + IdempotentKeyUtil.generate(method, joinPoint.getArgs()));
        String redisResponse = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (!StringUtils.isEmpty((Object)redisResponse)) {
            log.info("IdempotentAspect # joinPoint.getArgs():{}", (Object)JSON.toJSONString((Object)joinPoint.getArgs()));
            return RestResult.fail((String)"\u60a8\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)key, idempotent.expireMillis(), TimeUnit.MILLISECONDS);
        return joinPoint.proceed();
    }
}

