/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.behaviorfacade.utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public final class SpringContextUtil
implements ApplicationContextAware {
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (context == null) {
            context = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextUtil.checkApplicationContext();
        return context;
    }

    public static Object getBean(String name) {
        SpringContextUtil.checkApplicationContext();
        return context.getBean(name);
    }

    public static <T> T getBean(Class<T> beanClass) {
        SpringContextUtil.checkApplicationContext();
        return (T)context.getBean(beanClass);
    }

    public static void cleanApplicationContext() {
        context = null;
    }

    private static void checkApplicationContext() {
        if (context == null) {
            throw new IllegalStateException("applicaitonContext\u672a\u6ce8\u5165,\u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder");
        }
    }
}

