package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 订单表
 * </p>
 *
 * @author zhangrenjie@zhidemai.com
 * @since 2024-11-04
 */
@Getter
@Setter
public class TStaffOrderVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("code")
    private String orderCode;

    @ApiModelProperty("员工code")
    private String staffCode;

    @ApiModelProperty("是否会员订单：1-是，0-否")
    private Boolean memberOrder;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单标志 0退单订单标志不通过此字段判断 1是订单2是退单")
    private Integer orderFlag;

    @ApiModelProperty("原始订单号")
    private String originalOrderNo;

    @ApiModelProperty("订单状态 1:待付款,2:待发货,3:待收货,4:待评价,5:已取消,6:已全退,7:退款中,8:已评价,9:退货中")
    private String orderStatus;

    @ApiModelProperty("折扣价 * 数量")
    private BigDecimal tradeAmount;

    @ApiModelProperty("下单时间")
    private Date placeOrderTime;

    @ApiModelProperty("支付时间 ")
    private Date payTime;

    @ApiModelProperty("支付金额")
    private BigDecimal payMoney;

    @ApiModelProperty("机场编号")
    private String airportCode;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private Date createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private Date modifiedDate;

    @ApiModelProperty("版本号")
    private Integer version;

    @ApiModelProperty("订单明细")
    private List<TStaffOrderDetailVo> orderDetailList;

    @ApiModelProperty("订单支付")
    private List<TStaffOrderPaymentVo> orderPaymentList;
}
