package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 订单支付详情
 * </p>
 *
 * @author zhangrenjie@zhidemai.com
 * @since 2024-11-04
 */
@Getter
@Setter
public class TStaffOrderPaymentVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty("订单支付明细code")
    private String orderPaymentCode;

    @ApiModelProperty("所属订单")
    private String orderCode;

    @ApiModelProperty("金额")
    private BigDecimal payAmount;

    @ApiModelProperty("支付类型")
    private String payTypeId;

    @ApiModelProperty("支付单号")
    private String payNumber;

    @ApiModelProperty("支付使用的优惠券号")
    private String couponCode;

    @ApiModelProperty("使用积分")
    private Integer integralUsed;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private Date createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private Date modifiedDate;

    @ApiModelProperty("版本号")
    private Integer version;
}
