package com.bizvane.basic.feign.model.req.approve;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@ApiModel
public class AddOrModifyApproveConfigNodeReqVO {

    @ApiModelProperty("主键id(编辑的时候需要传)")
    private Long id;

    @ApiModelProperty("节点code")
    private String approveNodeCode;

    @ApiModelProperty(value = "节点名称")
    private String nodeName;

    @ApiModelProperty(value = "审批类型（1指定成员 2指定角色）")
    @NotNull(message = "审批类型不能为空")
    private Integer approveType;

    @ApiModelProperty(value = "审批成员、角色（多个用逗号隔开）")
    @NotBlank(message = "审批成员不能为空")
    private String approveTypeValue;

    @ApiModelProperty(value = "节点序号")
    @NotNull(message = "节点序号不能为空")
    private Integer nodeSort;
}
