package com.bizvane.basic.feign.feign;

import com.bizvane.basic.feign.model.req.approve.AuditApproveTaskRequestVO;
import com.bizvane.basic.feign.model.req.approve.QueryApproveTaskListRequestVO;
import com.bizvane.basic.feign.model.req.approve.QueryApproveTaskRequestVO;
import com.bizvane.basic.feign.model.req.approve.QueryUserRecentMessageRequestVO;
import com.bizvane.basic.feign.model.rsp.approve.QueryApproveTaskListResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicApproveTask")
@Api(value = "审批任务RPC")
public interface BasicApproveTaskRpcFeign {


    @PostMapping("/pageList")
    @ApiOperation(value = "分页查询列表")
    ResponseData<PageInfo<QueryApproveTaskListResponseVO>> pageList(@RequestBody @Validated QueryApproveTaskListRequestVO request);


    @PostMapping("/audit")
    @ApiOperation(value = "审核")
    ResponseData<Boolean> audit(@RequestBody @Validated AuditApproveTaskRequestVO request);


    @PostMapping("/detail")
    @ApiOperation(value = "详情")
    ResponseData<QueryApproveTaskListResponseVO> detail(@RequestBody @Validated QueryApproveTaskRequestVO request);


    @PostMapping("/processing/count")
    @ApiOperation(value = "待我处理审批任务数量、消息统计")
    ResponseData<Long> processingCount(@RequestBody QueryUserRecentMessageRequestVO request);
}
