package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 组织
 */
@Getter
@Setter
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class TBasicOrgTreeVo {

    @ApiModelProperty(value = "pkid")
    private Long id;

    @ApiModelProperty(value = "父级ID")
    private Long pid;

    @ApiModelProperty(value = "组织名称")
    private String orgName;

    @ApiModelProperty(value = "组织code")
    private String orgCode;

    @ApiModelProperty(value = "序号")
    private Integer sort;

    @ApiModelProperty(value = "创建人id")
    private String createUserCode;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建日期")
    private Date createDate;

    @ApiModelProperty(value = "修改人id")
    private String modifiedUserCode;

    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间")
    private Date modifiedDate;

    @ApiModelProperty(value = "数据有效性：1=有效；0=无效")
    private Boolean valid;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "子组织")
    private List<TBasicOrgTreeVo> children = new ArrayList<>();

}
