package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 加密、解密
 */
@Data
public class TSysCryptoDataVo implements Serializable {


    @ApiModelProperty(value = "数据data", required = true)
    @NotBlank(message = "数据不能为空")
    private String data;

    @ApiModelProperty(value = "业务类型（参考枚举：TSysCryptoDataBizTypeEnums）", required = true)
    @NotBlank(message = "业务类型不能为空")
    private String bizType;

    @ApiModelProperty(value = "操作人code", required = true)
    private String operatorCode;

    @ApiModelProperty("操作人名字")
    private String operatorName;


}
