package com.bizvane.basic.feign.model.req.approve;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Getter
@Setter
@ApiModel
public class AddApproveTaskReqVO {


    @ApiModelProperty("审批范围（组织code）")
    @NotBlank(message = "审批范围不能为空")
    private String approveRange;

    @ApiModelProperty("审批业务枚举：ApproveBusinessEnum")
    @NotBlank(message = "审批业务不能为空")
    private String approveBusiness;

    @ApiModelProperty("审批业务名称（自定义）")
    @NotBlank(message = "审批业务名称不能为空")
    private String approveBusinessName;

    @ApiModelProperty("审批内容（自定义）")
    @NotBlank(message = "审批内容不能为空")
    private String approveContent;

    @ApiModelProperty("关联业务ID（业务数据唯一code）")
    @NotBlank(message = "关联业务ID不能为空")
    private String refBusinessId;

    @ApiModelProperty("关联业务值（扩展字段）")
    private String refBusinessValue;

    @ApiModelProperty("申请人code")
    @NotNull(message = "申请人不能为空")
    private String applyUserCode;

    @ApiModelProperty("申请人名字")
    @NotNull(message = "申请人不能为空")
    private String applyUserName;

    @ApiModelProperty("申请时间")
    @NotNull(message = "申请时间不能为空")
    private Date applyTime;

    @ApiModelProperty("过期时间")
    private Date expireTime;

    @ApiModelProperty("创建人id")
    @NotNull
    private String createUserCode;

    @ApiModelProperty("创建人")
    @NotNull
    private String createUserName;

    @ApiModelProperty("备注")
    private String remark;
}
